/*
 * Decompiled with CFR 0.152.
 */
package de.javakaffee.web.msm;

import de.javakaffee.web.msm.BackupSessionTask;
import de.javakaffee.web.msm.MemcachedBackupSession;
import de.javakaffee.web.msm.MemcachedNodesManager;
import de.javakaffee.web.msm.NamedThreadFactory;
import de.javakaffee.web.msm.Statistics;
import de.javakaffee.web.msm.TranscoderService;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.annotation.Nonnull;
import net.spy.memcached.MemcachedClient;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;

public class BackupSessionService {
    private static final Log _log = LogFactory.getLog(BackupSessionService.class);
    private final TranscoderService _transcoderService;
    private final boolean _sessionBackupAsync;
    private final int _sessionBackupTimeout;
    private final MemcachedClient _memcached;
    private final MemcachedNodesManager _memcachedNodesManager;
    private final Statistics _statistics;
    private final ExecutorService _executorService;

    public BackupSessionService(TranscoderService transcoderService, boolean sessionBackupAsync, int sessionBackupTimeout, int backupThreadCount, MemcachedClient memcached, MemcachedNodesManager memcachedNodesManager, Statistics statistics) {
        this._transcoderService = transcoderService;
        this._sessionBackupAsync = sessionBackupAsync;
        this._sessionBackupTimeout = sessionBackupTimeout;
        this._memcached = memcached;
        this._memcachedNodesManager = memcachedNodesManager;
        this._statistics = statistics;
        this._executorService = sessionBackupAsync ? Executors.newFixedThreadPool(backupThreadCount, new NamedThreadFactory("msm-storage")) : new SynchronousExecutorService();
    }

    public void shutdown() {
        this._executorService.shutdown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateExpiration(MemcachedBackupSession session) throws InterruptedException {
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Updating expiration time for session " + session.getId()));
        }
        if (!this._memcachedNodesManager.getSessionIdFormat().isValid(session.getId())) {
            return;
        }
        session.setExpirationUpdateRunning(true);
        session.setLastBackupTime(System.currentTimeMillis());
        try {
            ConcurrentMap<String, Object> attributes = session.getAttributesFiltered();
            byte[] attributesData = this._transcoderService.serializeAttributes(session, attributes);
            byte[] data = this._transcoderService.serialize(session, attributesData);
            this.createBackupSessionTask(session, true).doBackupSession(session, data, attributesData);
        }
        finally {
            session.setExpirationUpdateRunning(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Future<BackupSessionTask.BackupResult> backupSession(MemcachedBackupSession session, boolean force) {
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Starting for session id " + session.getId()));
        }
        long start = System.currentTimeMillis();
        try {
            Future<BackupSessionTask.BackupResult> result;
            block14: {
                if (!this._memcachedNodesManager.getSessionIdFormat().isValid(session.getId())) {
                    if (_log.isDebugEnabled()) {
                        _log.debug((Object)("Skipping backup for session id " + session.getId() + " as the session id is not usable for memcached."));
                    }
                    this._statistics.requestWithBackupFailure();
                    SimpleFuture<BackupSessionTask.BackupResult> simpleFuture = new SimpleFuture<BackupSessionTask.BackupResult>(BackupSessionTask.BackupResult.FAILURE);
                    return simpleFuture;
                }
                if (!session.wasAccessedSinceLastBackupCheck() && !force) {
                    _log.debug((Object)"Session was not accessed since last backup/check, therefore we can skip this");
                    this._statistics.requestWithoutSessionAccess();
                    this.releaseLock(session);
                    SimpleFuture<BackupSessionTask.BackupResult> simpleFuture = new SimpleFuture<BackupSessionTask.BackupResult>(BackupSessionTask.BackupResult.SKIPPED);
                    return simpleFuture;
                }
                if (!(session.attributesAccessedSinceLastBackup() || force || session.authenticationChanged() || session.isNewInternal())) {
                    _log.debug((Object)"Session attributes were not accessed since last backup/check, therefore we can skip this");
                    this._statistics.requestWithoutAttributesAccess();
                    this.releaseLock(session);
                    SimpleFuture<BackupSessionTask.BackupResult> simpleFuture = new SimpleFuture<BackupSessionTask.BackupResult>(BackupSessionTask.BackupResult.SKIPPED);
                    return simpleFuture;
                }
                BackupSessionTask task = this.createBackupSessionTask(session, force);
                result = this._executorService.submit(task);
                if (!this._sessionBackupAsync) {
                    try {
                        result.get(this._sessionBackupTimeout, TimeUnit.MILLISECONDS);
                    }
                    catch (Exception e) {
                        if (!_log.isInfoEnabled()) break block14;
                        _log.info((Object)("Could not store session " + session.getId() + " in memcached."), (Throwable)e);
                    }
                }
            }
            Future<BackupSessionTask.BackupResult> future = result;
            return future;
        }
        finally {
            this._statistics.registerSince(Statistics.StatsType.EFFECTIVE_BACKUP, start);
        }
    }

    private BackupSessionTask createBackupSessionTask(MemcachedBackupSession session, boolean force) {
        return new BackupSessionTask(session, force, this._transcoderService, this._sessionBackupAsync, this._sessionBackupTimeout, this._memcached, this._memcachedNodesManager, this._statistics);
    }

    private void releaseLock(@Nonnull MemcachedBackupSession session) {
        if (session.isLocked()) {
            try {
                if (_log.isDebugEnabled()) {
                    _log.debug((Object)("Releasing lock for session " + session.getIdInternal()));
                }
                long start = System.currentTimeMillis();
                this._memcached.delete(this._memcachedNodesManager.getSessionIdFormat().createLockName(session.getIdInternal())).get();
                this._statistics.registerSince(Statistics.StatsType.RELEASE_LOCK, start);
                session.releaseLock();
            }
            catch (Exception e) {
                _log.warn((Object)("Caught exception when trying to release lock for session " + session.getIdInternal()), (Throwable)e);
            }
        }
    }

    static class SimpleFuture<T>
    implements Future<T> {
        private final T _result;
        private final ExecutionException _e;

        public SimpleFuture(T result) {
            this._result = result;
            this._e = null;
        }

        public SimpleFuture(ExecutionException e) {
            this._result = null;
            this._e = e;
        }

        @Override
        public boolean cancel(boolean mayInterruptIfRunning) {
            return true;
        }

        @Override
        public T get() throws InterruptedException, ExecutionException {
            if (this._e != null) {
                throw this._e;
            }
            return this._result;
        }

        @Override
        public T get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
            if (this._e != null) {
                throw this._e;
            }
            return this._result;
        }

        @Override
        public boolean isCancelled() {
            return false;
        }

        @Override
        public boolean isDone() {
            return true;
        }
    }

    static class SynchronousExecutorService
    implements ExecutorService {
        private boolean _shutdown;

        SynchronousExecutorService() {
        }

        @Override
        public boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
            return true;
        }

        @Override
        public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks) throws InterruptedException {
            throw new UnsupportedOperationException();
        }

        @Override
        public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) throws InterruptedException {
            throw new UnsupportedOperationException();
        }

        @Override
        public <T> T invokeAny(Collection<? extends Callable<T>> tasks) throws InterruptedException, ExecutionException {
            throw new UnsupportedOperationException();
        }

        @Override
        public <T> T invokeAny(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean isShutdown() {
            return this._shutdown;
        }

        @Override
        public boolean isTerminated() {
            return this._shutdown;
        }

        @Override
        public void shutdown() {
            this._shutdown = true;
        }

        @Override
        public List<Runnable> shutdownNow() {
            this.shutdown();
            return null;
        }

        @Override
        public <T> Future<T> submit(Callable<T> task) {
            try {
                return new SimpleFuture<T>(task.call());
            }
            catch (Exception e) {
                return new SimpleFuture(new ExecutionException(e));
            }
        }

        @Override
        public Future<?> submit(Runnable task) {
            try {
                task.run();
                return new SimpleFuture(null);
            }
            catch (Exception e) {
                return new SimpleFuture(new ExecutionException(e));
            }
        }

        @Override
        public <T> Future<T> submit(Runnable task, T result) {
            try {
                task.run();
                return new SimpleFuture<T>(result);
            }
            catch (Exception e) {
                return new SimpleFuture(new ExecutionException(e));
            }
        }

        @Override
        public void execute(Runnable command) {
            command.run();
        }
    }
}

