/*
 * Decompiled with CFR 0.152.
 */
package de.javakaffee.web.msm;

import de.javakaffee.web.msm.MemcachedNodesManager;
import de.javakaffee.web.msm.Statistics;
import de.javakaffee.web.msm.SuffixLocatorBinaryConnectionFactory;
import de.javakaffee.web.msm.SuffixLocatorConnectionFactory;
import javax.security.auth.callback.CallbackHandler;
import net.spy.memcached.BinaryConnectionFactory;
import net.spy.memcached.ConnectionFactory;
import net.spy.memcached.ConnectionFactoryBuilder;
import net.spy.memcached.DefaultConnectionFactory;
import net.spy.memcached.MemcachedClient;
import net.spy.memcached.auth.AuthDescriptor;
import net.spy.memcached.auth.PlainCallbackHandler;

public class MemcachedClientFactory {
    public static final String PROTOCOL_BINARY = "binary";

    protected MemcachedClient createMemcachedClient(MemcachedNodesManager memcachedNodesManager, String memcachedProtocol, String username, String password, long operationTimeout, long maxReconnectDelay, Statistics statistics) {
        try {
            ConnectionType connectionType = ConnectionType.valueOf(memcachedNodesManager.isCouchbaseBucketConfig(), username, password);
            if (connectionType.isCouchbaseBucketConfig()) {
                return this.createCouchbaseClient(memcachedNodesManager, memcachedProtocol, username, password, operationTimeout, maxReconnectDelay, statistics);
            }
            ConnectionFactory connectionFactory = this.createConnectionFactory(memcachedNodesManager, connectionType, memcachedProtocol, username, password, operationTimeout, maxReconnectDelay, statistics);
            return new MemcachedClient(connectionFactory, memcachedNodesManager.getAllMemcachedAddresses());
        }
        catch (Exception e) {
            throw new RuntimeException("Could not create memcached client", e);
        }
    }

    protected MemcachedClient createCouchbaseClient(MemcachedNodesManager memcachedNodesManager, String memcachedProtocol, String username, String password, long operationTimeout, long maxReconnectDelay, Statistics statistics) {
        try {
            CouchbaseClientFactory factory = Class.forName("de.javakaffee.web.msm.CouchbaseClientFactory").asSubclass(CouchbaseClientFactory.class).newInstance();
            return factory.createCouchbaseClient(memcachedNodesManager, memcachedProtocol, username, password, operationTimeout, maxReconnectDelay, statistics);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected ConnectionFactory createConnectionFactory(MemcachedNodesManager memcachedNodesManager, ConnectionType connectionType, String memcachedProtocol, String username, String password, final long operationTimeout, final long maxReconnectDelay, Statistics statistics) {
        if (PROTOCOL_BINARY.equals(memcachedProtocol)) {
            if (connectionType.isSASL()) {
                AuthDescriptor authDescriptor = new AuthDescriptor(new String[]{"PLAIN"}, (CallbackHandler)new PlainCallbackHandler(username, password));
                return memcachedNodesManager.isEncodeNodeIdInSessionId() ? new SuffixLocatorBinaryConnectionFactory(memcachedNodesManager, memcachedNodesManager.getSessionIdFormat(), statistics, operationTimeout, maxReconnectDelay, authDescriptor) : new ConnectionFactoryBuilder().setProtocol(ConnectionFactoryBuilder.Protocol.BINARY).setAuthDescriptor(authDescriptor).setOpTimeout(operationTimeout).setMaxReconnectDelay(maxReconnectDelay).build();
            }
            return memcachedNodesManager.isEncodeNodeIdInSessionId() ? new SuffixLocatorBinaryConnectionFactory(memcachedNodesManager, memcachedNodesManager.getSessionIdFormat(), statistics, operationTimeout, maxReconnectDelay) : new BinaryConnectionFactory(){

                public long getOperationTimeout() {
                    return operationTimeout;
                }

                public long getMaxReconnectDelay() {
                    return maxReconnectDelay;
                }
            };
        }
        return memcachedNodesManager.isEncodeNodeIdInSessionId() ? new SuffixLocatorConnectionFactory(memcachedNodesManager, memcachedNodesManager.getSessionIdFormat(), statistics, operationTimeout, maxReconnectDelay) : new DefaultConnectionFactory(){

            public long getOperationTimeout() {
                return operationTimeout;
            }

            public long getMaxReconnectDelay() {
                return maxReconnectDelay;
            }
        };
    }

    static class ConnectionType {
        private final boolean couchbaseBucketConfig;
        private final String username;
        private final String password;

        public ConnectionType(boolean couchbaseBucketConfig, String username, String password) {
            this.couchbaseBucketConfig = couchbaseBucketConfig;
            this.username = username;
            this.password = password;
        }

        public static ConnectionType valueOf(boolean couchbaseBucketConfig, String username, String password) {
            return new ConnectionType(couchbaseBucketConfig, username, password);
        }

        boolean isCouchbaseBucketConfig() {
            return this.couchbaseBucketConfig;
        }

        boolean isSASL() {
            return !this.couchbaseBucketConfig && !this.isBlank(this.username) && !this.isBlank(this.password);
        }

        boolean isDefault() {
            return !this.isCouchbaseBucketConfig() && !this.isSASL();
        }

        boolean isBlank(String value) {
            return value == null || value.trim().length() == 0;
        }
    }

    static interface CouchbaseClientFactory {
        public MemcachedClient createCouchbaseClient(MemcachedNodesManager var1, String var2, String var3, String var4, long var5, long var7, Statistics var9);
    }
}

