/*
 * Decompiled with CFR 0.152.
 */
package de.juplo.plugins.hibernate4;

import com.pyx4j.log4j.MavenLogAppender;
import de.juplo.plugins.hibernate4.ValidationConfiguration;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.math.BigInteger;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.DriverPropertyInfo;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.Collection;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.TreeSet;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.persistence.Embeddable;
import javax.persistence.Entity;
import javax.persistence.MappedSuperclass;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.model.Resource;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.project.MavenProject;
import org.hibernate.cfg.Configuration;
import org.hibernate.cfg.NamingStrategy;
import org.hibernate.envers.configuration.spi.AuditConfiguration;
import org.hibernate.tool.hbm2ddl.SchemaExport;
import org.hibernate.tool.hbm2ddl.Target;
import org.scannotation.AnnotationDB;

public class Hbm2DdlMojo
extends AbstractMojo {
    public static final String EXPORT_SKIPPED_PROPERTY = "hibernate.export.skipped";
    public static final String DRIVER_CLASS = "hibernate.connection.driver_class";
    public static final String URL = "hibernate.connection.url";
    public static final String USERNAME = "hibernate.connection.username";
    public static final String PASSWORD = "hibernate.connection.password";
    public static final String DIALECT = "hibernate.dialect";
    public static final String NAMING_STRATEGY = "hibernate.ejb.naming_strategy";
    public static final String ENVERS = "hibernate.export.envers";
    public static final String MD5S = "hibernate4-generatedschema.md5s";
    private static final Pattern split = Pattern.compile("[^,\\s]+");
    private MavenProject project;
    private String buildDirectory;
    private String outputDirectory;
    private boolean scanTestClasses;
    private String scanDependencies;
    private String testOutputDirectory;
    private boolean skip;
    private boolean force;
    private String driverClassName;
    private String url;
    private String username;
    private String password;
    private String hibernateDialect;
    private String hibernateNamingStrategy;
    private String hibernateProperties;
    private String hibernateMapping;
    private String target;
    private String type;
    private String outputFile;
    private String delimiter;
    private boolean format;
    private boolean envers;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() throws MojoFailureException, MojoExecutionException {
        String dialect;
        HashMap md5s;
        if (this.skip) {
            this.getLog().info((CharSequence)"Execution of hibernate4-maven-plugin:export was skipped!");
            this.project.getProperties().setProperty(EXPORT_SKIPPED_PROPERTY, "true");
            return;
        }
        boolean modified = false;
        File saved = new File(this.buildDirectory + File.separator + MD5S);
        if (saved.isFile() && saved.length() > 0L) {
            try {
                FileInputStream fis = new FileInputStream(saved);
                ObjectInputStream ois = new ObjectInputStream(fis);
                md5s = (HashMap)ois.readObject();
                ois.close();
            }
            catch (Exception e) {
                md5s = new HashMap();
                this.getLog().warn((CharSequence)("Cannot read timestamps from saved: " + e));
            }
        } else {
            md5s = new HashMap();
            try {
                saved.createNewFile();
            }
            catch (IOException e) {
                this.getLog().debug((CharSequence)("Cannot create file \"" + saved.getPath() + "\" for timestamps: " + e));
            }
        }
        URLClassLoader classLoader = null;
        try {
            this.getLog().debug((CharSequence)"Creating ClassLoader for project-dependencies...");
            List classpathFiles = this.project.getCompileClasspathElements();
            if (this.scanTestClasses) {
                classpathFiles.addAll(this.project.getTestClasspathElements());
            }
            URL[] urls = new URL[classpathFiles.size()];
            for (int i = 0; i < classpathFiles.size(); ++i) {
                this.getLog().debug((CharSequence)("Dependency: " + (String)classpathFiles.get(i)));
                urls[i] = new File((String)classpathFiles.get(i)).toURI().toURL();
            }
            classLoader = new URLClassLoader(urls, ((Object)((Object)this)).getClass().getClassLoader());
        }
        catch (Exception e) {
            this.getLog().error((CharSequence)"Error while creating ClassLoader!", (Throwable)e);
            throw new MojoExecutionException(e.getMessage());
        }
        TreeSet<Class> classes = new TreeSet<Class>(new Comparator<Class<?>>(){

            @Override
            public int compare(Class<?> a, Class<?> b) {
                return a.getName().compareTo(b.getName());
            }
        });
        try {
            URL dirUrl;
            AnnotationDB db = new AnnotationDB();
            File dir = new File(this.outputDirectory);
            if (dir.exists()) {
                this.getLog().info((CharSequence)("Scanning directory " + this.outputDirectory + " for annotated classes..."));
                dirUrl = dir.toURI().toURL();
                db.scanArchives(new URL[]{dirUrl});
            }
            if (this.scanTestClasses && (dir = new File(this.testOutputDirectory)).exists()) {
                this.getLog().info((CharSequence)("Scanning directory " + this.testOutputDirectory + " for annotated classes..."));
                dirUrl = dir.toURI().toURL();
                db.scanArchives(new URL[]{dirUrl});
            }
            if (this.scanDependencies != null) {
                Matcher matcher = split.matcher(this.scanDependencies);
                while (matcher.find()) {
                    this.getLog().info((CharSequence)("Scanning dependencies for scope " + matcher.group()));
                    for (Artifact artifact : this.project.getDependencyArtifacts()) {
                        if (!artifact.getScope().equalsIgnoreCase(matcher.group())) continue;
                        if (artifact.getFile() == null) {
                            this.getLog().warn((CharSequence)("Cannot scan dependency " + artifact.getId() + ": no JAR-file available!"));
                            continue;
                        }
                        this.getLog().info((CharSequence)("Scanning dependency " + artifact.getId() + " for annotated classes..."));
                        db.scanArchives(new URL[]{artifact.getFile().toURI().toURL()});
                    }
                }
            }
            HashSet classNames = new HashSet();
            if (db.getAnnotationIndex().containsKey(Entity.class.getName())) {
                classNames.addAll((Collection)db.getAnnotationIndex().get(Entity.class.getName()));
            }
            if (db.getAnnotationIndex().containsKey(MappedSuperclass.class.getName())) {
                classNames.addAll((Collection)db.getAnnotationIndex().get(MappedSuperclass.class.getName()));
            }
            if (db.getAnnotationIndex().containsKey(Embeddable.class.getName())) {
                classNames.addAll((Collection)db.getAnnotationIndex().get(Embeddable.class.getName()));
            }
            MessageDigest digest = MessageDigest.getInstance("MD5");
            for (String name : classNames) {
                String oldMd5;
                int i;
                Class annotatedClass = classLoader.loadClass(name);
                classes.add(annotatedClass);
                String resourceName = annotatedClass.getName();
                resourceName = resourceName.substring(resourceName.lastIndexOf(".") + 1, resourceName.length()) + ".class";
                InputStream is = annotatedClass.getResourceAsStream(resourceName);
                byte[] buffer = new byte[4096];
                while ((i = is.read(buffer)) > -1) {
                    digest.update(buffer, 0, i);
                }
                is.close();
                byte[] bytes = digest.digest();
                BigInteger bi = new BigInteger(1, bytes);
                String newMd5 = String.format("%0" + (bytes.length << 1) + "x", bi);
                String string = oldMd5 = !md5s.containsKey(name) ? "" : (String)md5s.get(name);
                if (!newMd5.equals(oldMd5)) {
                    this.getLog().debug((CharSequence)("Found new or modified annotated class: " + name));
                    modified = true;
                    md5s.put(name, newMd5);
                    continue;
                }
                this.getLog().debug((CharSequence)(oldMd5 + " -> class unchanged: " + name));
            }
        }
        catch (ClassNotFoundException e) {
            this.getLog().error((CharSequence)"Error while adding annotated classes!", (Throwable)e);
            throw new MojoExecutionException(e.getMessage());
        }
        catch (Exception e) {
            this.getLog().error((CharSequence)"Error while scanning!", (Throwable)e);
            throw new MojoFailureException(e.getMessage());
        }
        if (classes.isEmpty()) {
            if (this.hibernateMapping == null || this.hibernateMapping.isEmpty()) {
                throw new MojoFailureException("No annotated classes found in directory " + this.outputDirectory);
            }
        } else {
            this.getLog().debug((CharSequence)"Detected classes with mapping-annotations:");
            for (Class annotatedClass : classes) {
                this.getLog().debug((CharSequence)("  " + annotatedClass.getName()));
            }
        }
        Properties properties = new Properties();
        try {
            File file = new File(this.hibernateProperties);
            if (file.exists()) {
                this.getLog().info((CharSequence)("Reading properties from file " + this.hibernateProperties + "..."));
                properties.load(new FileInputStream(file));
            } else {
                this.getLog().info((CharSequence)("No hibernate-properties-file found! (Checked path: " + this.hibernateProperties + ")"));
            }
        }
        catch (IOException e) {
            this.getLog().error((CharSequence)"Error while reading properties!", (Throwable)e);
            throw new MojoExecutionException(e.getMessage());
        }
        if (this.driverClassName != null) {
            if (properties.containsKey(DRIVER_CLASS)) {
                this.getLog().debug((CharSequence)("Overwriting property hibernate.connection.driver_class=" + properties.getProperty(DRIVER_CLASS) + " with the value " + this.driverClassName));
            } else {
                this.getLog().debug((CharSequence)("Using the value " + this.driverClassName));
            }
            properties.setProperty(DRIVER_CLASS, this.driverClassName);
        }
        if (this.url != null) {
            if (properties.containsKey(URL)) {
                this.getLog().debug((CharSequence)("Overwriting property hibernate.connection.url=" + properties.getProperty(URL) + " with the value " + this.url));
            } else {
                this.getLog().debug((CharSequence)("Using the value " + this.url));
            }
            properties.setProperty(URL, this.url);
        }
        if (this.username != null) {
            if (properties.containsKey(USERNAME)) {
                this.getLog().debug((CharSequence)("Overwriting property hibernate.connection.username=" + properties.getProperty(USERNAME) + " with the value " + this.username));
            } else {
                this.getLog().debug((CharSequence)("Using the value " + this.username));
            }
            properties.setProperty(USERNAME, this.username);
        }
        if (this.password != null) {
            if (properties.containsKey(PASSWORD)) {
                this.getLog().debug((CharSequence)("Overwriting property hibernate.connection.password=" + properties.getProperty(PASSWORD) + " with value " + this.password));
            } else {
                this.getLog().debug((CharSequence)("Using value " + this.password + " for property " + PASSWORD));
            }
            properties.setProperty(PASSWORD, this.password);
        }
        if (this.hibernateDialect != null) {
            if (properties.containsKey(DIALECT)) {
                this.getLog().debug((CharSequence)("Overwriting property hibernate.dialect=" + properties.getProperty(DIALECT) + " with value " + this.hibernateDialect));
            } else {
                this.getLog().debug((CharSequence)("Using value " + this.hibernateDialect + " for property " + DIALECT));
            }
            properties.setProperty(DIALECT, this.hibernateDialect);
        } else {
            this.hibernateDialect = properties.getProperty(DIALECT);
        }
        if (this.hibernateNamingStrategy != null) {
            if (properties.contains(NAMING_STRATEGY)) {
                this.getLog().debug((CharSequence)("Overwriting property hibernate.ejb.naming_strategy=" + properties.getProperty(NAMING_STRATEGY) + " with value " + this.hibernateNamingStrategy));
            } else {
                this.getLog().debug((CharSequence)("Using value " + this.hibernateNamingStrategy + " for property " + NAMING_STRATEGY));
            }
            properties.setProperty(NAMING_STRATEGY, this.hibernateNamingStrategy);
        }
        if (md5s.containsKey(DIALECT)) {
            dialect = properties.getProperty(DIALECT);
            if (((String)md5s.get(DIALECT)).equals(dialect)) {
                this.getLog().debug((CharSequence)"SQL-dialect unchanged.");
            } else {
                modified = true;
                if (dialect == null) {
                    this.getLog().debug((CharSequence)"SQL-dialect was unset.");
                    md5s.remove(DIALECT);
                } else {
                    this.getLog().debug((CharSequence)("SQL-dialect changed: " + dialect));
                    md5s.put(DIALECT, dialect);
                }
            }
        } else {
            dialect = properties.getProperty(DIALECT);
            if (dialect != null) {
                modified = true;
                md5s.put(DIALECT, properties.getProperty(DIALECT));
            }
        }
        if (md5s.get(ENVERS) != null) {
            if (((String)md5s.get(ENVERS)).equals(Boolean.toString(this.envers))) {
                this.getLog().debug((CharSequence)("Envers-Configuration unchanged. Enabled: " + this.envers));
            } else {
                this.getLog().debug((CharSequence)("Envers-Configuration changed. Enabled: " + this.envers));
                modified = true;
                md5s.put(ENVERS, Boolean.toString(this.envers));
            }
        } else {
            modified = true;
            md5s.put(ENVERS, Boolean.toString(this.envers));
        }
        if (properties.isEmpty()) {
            this.getLog().error((CharSequence)"No properties set!");
            throw new MojoFailureException("Hibernate configuration is missing!");
        }
        ValidationConfiguration config = new ValidationConfiguration(this.hibernateDialect);
        config.setProperties(properties);
        if (properties.containsKey(NAMING_STRATEGY)) {
            String namingStrategy = properties.getProperty(NAMING_STRATEGY);
            this.getLog().debug((CharSequence)("Explicitly set NamingStrategy: " + namingStrategy));
            try {
                Class<?> namingStrategyClass = Class.forName(namingStrategy);
                config.setNamingStrategy((NamingStrategy)namingStrategyClass.newInstance());
            }
            catch (Exception e) {
                this.getLog().error((CharSequence)"Error setting NamingStrategy", (Throwable)e);
                throw new MojoExecutionException(e.getMessage());
            }
        }
        ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
        Connection connection = null;
        MavenLogAppender.startPluginLog((AbstractMojo)this);
        try {
            File outFileParentDir;
            Thread.currentThread().setContextClassLoader(classLoader);
            this.getLog().debug((CharSequence)"Adding annotated classes to hibernate-mapping-configuration...");
            HashSet<String> packages = new HashSet<String>();
            for (Class annotatedClass : classes) {
                String packageName = annotatedClass.getPackage().getName();
                if (!packages.contains(packageName)) {
                    this.getLog().debug((CharSequence)("Add package " + packageName));
                    packages.add(packageName);
                    config.addPackage(packageName);
                    this.getLog().debug((CharSequence)("type definintions" + config.getTypeDefs()));
                }
                this.getLog().debug((CharSequence)("Class " + annotatedClass));
                config.addAnnotatedClass(annotatedClass);
            }
            if (this.hibernateMapping != null) {
                try {
                    MessageDigest digest = MessageDigest.getInstance("MD5");
                    for (String filename : this.hibernateMapping.split("[\\s,]+")) {
                        File file = new File(filename);
                        if (!file.exists()) {
                            Resource resource;
                            Iterator i$ = this.project.getResources().iterator();
                            while (i$.hasNext() && !(file = new File((resource = (Resource)i$.next()).getDirectory() + File.separator + filename)).exists()) {
                            }
                        }
                        if (file != null && file.exists()) {
                            String oldMd5;
                            int i;
                            FileInputStream is = new FileInputStream(file);
                            byte[] buffer = new byte[4096];
                            while ((i = ((InputStream)is).read(buffer)) > -1) {
                                digest.update(buffer, 0, i);
                            }
                            ((InputStream)is).close();
                            byte[] bytes = digest.digest();
                            BigInteger bi = new BigInteger(1, bytes);
                            String newMd5 = String.format("%0" + (bytes.length << 1) + "x", bi);
                            String string = oldMd5 = !md5s.containsKey(filename) ? "" : (String)md5s.get(filename);
                            if (!newMd5.equals(oldMd5)) {
                                this.getLog().debug((CharSequence)("Found new or modified mapping-file: " + filename));
                                modified = true;
                                md5s.put(filename, newMd5);
                            } else {
                                this.getLog().debug((CharSequence)(oldMd5 + " -> mapping-file unchanged: " + filename));
                            }
                        } else {
                            throw new MojoFailureException("File " + filename + " could not be found in any of the configured resource-directories!");
                        }
                        this.getLog().debug((CharSequence)("Adding mappings from XML-configurationfile: " + file));
                        config.addFile(file);
                    }
                }
                catch (NoSuchAlgorithmException e) {
                    throw new MojoFailureException("Cannot calculate MD5 sums!", (Throwable)e);
                }
                catch (FileNotFoundException e) {
                    throw new MojoFailureException("Cannot calculate MD5 sums!", (Throwable)e);
                }
                catch (IOException e) {
                    throw new MojoFailureException("Cannot calculate MD5 sums!", (Throwable)e);
                }
            }
            Target target = null;
            try {
                target = Target.valueOf((String)this.target.toUpperCase());
            }
            catch (IllegalArgumentException e) {
                this.getLog().error((CharSequence)("Invalid value for configuration-option \"target\": " + this.target));
                this.getLog().error((CharSequence)"Valid values are: NONE, SCRIPT, EXPORT, BOTH");
                throw new MojoExecutionException("Invalid value for configuration-option \"target\"");
            }
            SchemaExport.Type type = null;
            try {
                type = SchemaExport.Type.valueOf((String)this.type.toUpperCase());
            }
            catch (IllegalArgumentException e) {
                this.getLog().error((CharSequence)("Invalid value for configuration-option \"type\": " + this.type));
                this.getLog().error((CharSequence)"Valid values are: NONE, CREATE, DROP, BOTH");
                throw new MojoExecutionException("Invalid value for configuration-option \"type\"");
            }
            if (target.equals((Object)Target.SCRIPT) || target.equals((Object)Target.NONE)) {
                this.project.getProperties().setProperty(EXPORT_SKIPPED_PROPERTY, "true");
            }
            if (!(modified || target.equals((Object)Target.SCRIPT) || target.equals((Object)Target.NONE) || this.force)) {
                this.getLog().info((CharSequence)"No modified annotated classes or mapping-files found and dialect unchanged.");
                this.getLog().info((CharSequence)"Skipping schema generation!");
                this.project.getProperties().setProperty(EXPORT_SKIPPED_PROPERTY, "true");
                return;
            }
            this.getLog().info((CharSequence)"Gathered hibernate-configuration (turn on debugging for details):");
            for (Map.Entry<Object, Object> entry : properties.entrySet()) {
                this.getLog().info((CharSequence)("  " + entry.getKey() + " = " + entry.getValue()));
            }
            try {
                this.getLog().debug((CharSequence)("Target: " + target + ", Type: " + type));
                switch (target) {
                    case EXPORT: 
                    case BOTH: {
                        switch (type) {
                            case CREATE: 
                            case DROP: 
                            case BOTH: {
                                Class<?> driverClass = classLoader.loadClass(properties.getProperty(DRIVER_CLASS));
                                this.getLog().debug((CharSequence)("Registering JDBC-driver " + driverClass.getName()));
                                DriverManager.registerDriver(new DriverProxy((Driver)driverClass.newInstance()));
                                this.getLog().debug((CharSequence)("Opening JDBC-connection to " + properties.getProperty(URL) + " as " + properties.getProperty(USERNAME) + " with password " + properties.getProperty(PASSWORD)));
                                connection = DriverManager.getConnection(properties.getProperty(URL), properties.getProperty(USERNAME), properties.getProperty(PASSWORD));
                            }
                        }
                    }
                }
            }
            catch (ClassNotFoundException e) {
                this.getLog().error((CharSequence)("Dependency for driver-class " + properties.getProperty(DRIVER_CLASS) + " is missing!"));
                throw new MojoExecutionException(e.getMessage());
            }
            catch (Exception e) {
                this.getLog().error((CharSequence)"Cannot establish connection to database!");
                Enumeration<Driver> drivers = DriverManager.getDrivers();
                if (!drivers.hasMoreElements()) {
                    this.getLog().error((CharSequence)"No drivers registered!");
                }
                while (drivers.hasMoreElements()) {
                    this.getLog().debug((CharSequence)("Driver: " + drivers.nextElement()));
                }
                throw new MojoExecutionException(e.getMessage());
            }
            config.buildMappings();
            if (this.envers) {
                this.getLog().info((CharSequence)"Automatic auditing via hibernate-envers enabled!");
                AuditConfiguration.getFor((Configuration)config);
            }
            SchemaExport export = new SchemaExport((Configuration)config, connection);
            export.setDelimiter(this.delimiter);
            export.setFormat(this.format);
            File outF = new File(this.outputFile);
            if (!outF.isAbsolute()) {
                outF = new File(this.buildDirectory, this.outputFile);
                this.getLog().info((CharSequence)("Adjusted relative path, resulting path is " + outF.getPath()));
            }
            if (null != (outFileParentDir = outF.getParentFile()) && !outFileParentDir.exists()) {
                try {
                    this.getLog().info((CharSequence)("Creating directory path for output file:" + outFileParentDir.getPath()));
                    outFileParentDir.mkdirs();
                }
                catch (Exception e) {
                    this.getLog().error((CharSequence)("Error creating directory path for output file: " + e.getLocalizedMessage()));
                }
            }
            export.setOutputFile(outF.getPath());
            export.execute(target, type);
            for (Object exception : export.getExceptions()) {
                this.getLog().debug((CharSequence)exception.toString());
            }
        }
        finally {
            MavenLogAppender.endPluginLog((AbstractMojo)this);
            Thread.currentThread().setContextClassLoader(contextClassLoader);
            try {
                if (connection != null) {
                    connection.close();
                }
            }
            catch (SQLException e) {
                this.getLog().error((CharSequence)("Error while closing connection: " + e.getMessage()));
            }
        }
        try {
            FileOutputStream fos = new FileOutputStream(saved);
            ObjectOutputStream oos = new ObjectOutputStream(fos);
            oos.writeObject(md5s);
            oos.close();
            fos.close();
        }
        catch (Exception e) {
            this.getLog().error((CharSequence)("Cannot write md5-sums to file: " + e));
        }
    }

    static final class DriverProxy
    implements Driver {
        private final Driver target;

        DriverProxy(Driver target) {
            if (target == null) {
                throw new NullPointerException();
            }
            this.target = target;
        }

        public Driver getTarget() {
            return this.target;
        }

        @Override
        public boolean acceptsURL(String url) throws SQLException {
            return this.target.acceptsURL(url);
        }

        @Override
        public Connection connect(String url, Properties info) throws SQLException {
            return this.target.connect(url, info);
        }

        @Override
        public int getMajorVersion() {
            return this.target.getMajorVersion();
        }

        @Override
        public int getMinorVersion() {
            return this.target.getMinorVersion();
        }

        @Override
        public DriverPropertyInfo[] getPropertyInfo(String url, Properties info) throws SQLException {
            return this.target.getPropertyInfo(url, info);
        }

        @Override
        public boolean jdbcCompliant() {
            return this.target.jdbcCompliant();
        }

        @Override
        public Logger getParentLogger() throws SQLFeatureNotSupportedException {
            throw new SQLFeatureNotSupportedException("Not supported, for backward-compatibility with Java 1.6");
        }

        public String toString() {
            return "Proxy: " + this.target;
        }

        public int hashCode() {
            return this.target.hashCode();
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof DriverProxy)) {
                return false;
            }
            DriverProxy other = (DriverProxy)obj;
            return this.target.equals(other.target);
        }
    }
}

