/*
 * Decompiled with CFR 0.152.
 */
package de.larmic.butterfaces.component.base.renderer;

import java.io.IOException;
import java.util.Collections;
import java.util.Iterator;
import java.util.logging.Logger;
import javax.faces.component.UIComponent;
import javax.faces.component.behavior.ClientBehaviorHolder;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.render.Renderer;

public class HtmlBasicRenderer
extends Renderer {
    private static final Logger LOGGER = Logger.getLogger(HtmlBasicRenderer.class.getName());
    public static final String ELEMENT_DIV = "div";
    public static final String ELEMENT_SPAN = "span";
    public static final String ELEMENT_SECTION = "section";
    public static final String ATTRIBUTE_ID = "id";
    public static final String ATTRIBUTE_STYLE = "style";
    public static final String ATTRIBUTE_CLASS = "class";

    protected void rendererParamsNotNull(FacesContext context, UIComponent component) {
        this.notNull("context", context);
        this.notNull("component", component);
    }

    private void notNull(String varname, Object var) {
        if (var == null) {
            throw new NullPointerException(varname);
        }
    }

    protected boolean shouldEncode(UIComponent component) {
        return component.isRendered();
    }

    protected String writeIdAttributeIfNecessary(FacesContext context, ResponseWriter writer, UIComponent component) throws IOException {
        if (this.shouldWriteIdAttribute(component)) {
            return this.writeIdAttribute(context, writer, component);
        }
        return null;
    }

    protected String writeIdAttribute(FacesContext context, ResponseWriter writer, UIComponent component) throws IOException {
        String clientId = component.getClientId(context);
        writer.writeAttribute(ATTRIBUTE_ID, (Object)clientId, ATTRIBUTE_ID);
        return clientId;
    }

    protected boolean shouldWriteIdAttribute(UIComponent component) {
        String id = component.getId();
        return null != id && (!id.startsWith("j_id") || component instanceof ClientBehaviorHolder && !((ClientBehaviorHolder)component).getClientBehaviors().isEmpty());
    }

    protected void encodeRecursive(FacesContext context, UIComponent component) throws IOException {
        if (!component.isRendered()) {
            return;
        }
        component.encodeBegin(context);
        if (component.getRendersChildren()) {
            component.encodeChildren(context);
        } else {
            Iterator<UIComponent> kids = this.getChildren(component);
            while (kids.hasNext()) {
                UIComponent kid = kids.next();
                this.encodeRecursive(context, kid);
            }
        }
        component.encodeEnd(context);
    }

    protected Iterator<UIComponent> getChildren(UIComponent component) {
        int childCount = component.getChildCount();
        if (childCount > 0) {
            return component.getChildren().iterator();
        }
        return Collections.emptyList().iterator();
    }

    protected UIComponent getFacet(UIComponent component, String name) {
        UIComponent facet = component.getFacet(name);
        return facet != null && facet.isRendered() ? facet : null;
    }
}

