/*
 * Decompiled with CFR 0.152.
 */
package de.larmic.butterfaces.component.html.table;

import de.larmic.butterfaces.component.html.table.HtmlColumn;
import de.larmic.butterfaces.component.partrenderer.StringUtils;
import de.larmic.butterfaces.event.TableSingleSelectionListener;
import de.larmic.butterfaces.model.json.Ordering;
import de.larmic.butterfaces.model.table.TableColumnOrdering;
import de.larmic.butterfaces.model.table.TableColumnOrderingModel;
import de.larmic.butterfaces.model.table.TableColumnVisibilityModel;
import de.larmic.butterfaces.model.table.TableModel;
import de.larmic.butterfaces.model.table.TableRowSortingModel;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import javax.el.ValueExpression;
import javax.faces.FacesException;
import javax.faces.application.ResourceDependencies;
import javax.faces.application.ResourceDependency;
import javax.faces.component.ContextCallback;
import javax.faces.component.FacesComponent;
import javax.faces.component.UIComponent;
import javax.faces.component.UIData;
import javax.faces.component.behavior.ClientBehaviorHolder;
import javax.faces.context.FacesContext;

@ResourceDependencies(value={@ResourceDependency(library="butterfaces-configurable", name="jquery.min.js", target="head"), @ResourceDependency(library="butterfaces-configurable", name="bootstrap.min.css", target="head"), @ResourceDependency(library="butterfaces-configurable", name="bootstrap.min.js", target="head"), @ResourceDependency(library="butterfaces-css", name="butterfaces-table.css", target="head"), @ResourceDependency(library="butterfaces-js", name="butterfaces-bootstrap-fixes.jquery.js", target="head"), @ResourceDependency(library="butterfaces-js", name="butterfaces-disableElements.jquery.js", target="head"), @ResourceDependency(library="butterfaces-js", name="butterfaces-ajax.js", target="head"), @ResourceDependency(library="butterfaces-js", name="butterfaces-table.jquery.js", target="head")})
@FacesComponent(value="de.larmic.butterfaces.component.table")
public class HtmlTable
extends UIData
implements ClientBehaviorHolder {
    public static final String COMPONENT_TYPE = "de.larmic.butterfaces.component.table";
    public static final String COMPONENT_FAMILY = "de.larmic.butterfaces.component.family";
    public static final String RENDERER_TYPE = "de.larmic.butterfaces.renderkit.html_basic.TableRenderer";
    protected static final String PROPERTY_SINGLE_SELECTION_LISTENER = "singleSelectionListener";
    protected static final String PROPERTY_MODEL = "model";
    protected static final String PROPERTY_TABLE_CONDENSED = "tableCondensed";
    protected static final String PROPERTY_TABLE_BORDERED = "tableBordered";
    protected static final String PROPERTY_TABLE_STRIPED = "tableStriped";
    protected static final String PROPERTY_TABLE_ROW_CLASS = "rowClass";
    protected static final String PROPERTY_AJAX_DISABLE_RENDER_REGION_ON_REQUEST = "ajaxDisableRenderRegionsOnRequest";
    protected static final String PROPERTY_UNIQUE_IDENTIFIER = "uniqueIdentifier";
    private final List<HtmlColumn> cachedColumns = new ArrayList<HtmlColumn>();

    public HtmlTable() {
        this.setRendererType(RENDERER_TYPE);
    }

    public Collection<String> getEventNames() {
        return Arrays.asList("click");
    }

    public String getDefaultEventName() {
        return "click";
    }

    public String getFamily() {
        return COMPONENT_FAMILY;
    }

    public List<HtmlColumn> getCachedColumns() {
        int childCount = this.getChildCount();
        if (childCount > 0 && this.cachedColumns.isEmpty()) {
            for (UIComponent uiComponent : this.getChildren()) {
                if (!(uiComponent instanceof HtmlColumn) || !uiComponent.isRendered()) continue;
                HtmlColumn column = (HtmlColumn)uiComponent;
                this.cachedColumns.add(column);
            }
        }
        this.getChildren().clear();
        if (this.getTableOrderingModel() != null) {
            ArrayList<HtmlColumn> notOrderedByModelColumnIdentifiers = new ArrayList<HtmlColumn>();
            ArrayList<Ordering> existingOrderings = new ArrayList<Ordering>();
            for (HtmlColumn htmlColumn : this.cachedColumns) {
                Integer n = this.getTableOrderingModel().getOrderPosition(this.getModelUniqueIdentifier(), htmlColumn.getModelUniqueIdentifier());
                if (n == null) {
                    notOrderedByModelColumnIdentifiers.add(htmlColumn);
                    continue;
                }
                existingOrderings.add(new Ordering(htmlColumn.getModelUniqueIdentifier(), n));
            }
            if (!notOrderedByModelColumnIdentifiers.isEmpty()) {
                Ordering.sort(existingOrderings);
                ArrayList<String> orderings = new ArrayList<String>();
                for (Ordering ordering : existingOrderings) {
                    orderings.add(ordering.getIdentifier());
                }
                for (HtmlColumn htmlColumn : notOrderedByModelColumnIdentifiers) {
                    orderings.add(htmlColumn.getModelUniqueIdentifier());
                }
                TableColumnOrdering tableColumnOrdering = new TableColumnOrdering(this.getModelUniqueIdentifier(), orderings);
                this.getTableOrderingModel().update(tableColumnOrdering);
            }
            Collections.sort(this.cachedColumns, new Comparator<HtmlColumn>(){

                @Override
                public int compare(HtmlColumn o1, HtmlColumn o2) {
                    if (HtmlTable.this.getTableOrderingModel() != null) {
                        Integer orderPosition = HtmlTable.this.getTableOrderingModel().getOrderPosition(HtmlTable.this.getModelUniqueIdentifier(), o1.getModelUniqueIdentifier());
                        Integer o2OrderPosition = HtmlTable.this.getTableOrderingModel().getOrderPosition(HtmlTable.this.getModelUniqueIdentifier(), o2.getModelUniqueIdentifier());
                        if (orderPosition != null && o2OrderPosition != null) {
                            return orderPosition.compareTo(o2OrderPosition);
                        }
                    }
                    return 0;
                }
            });
        }
        for (HtmlColumn cachedColumn : this.cachedColumns) {
            this.getChildren().add(cachedColumn);
        }
        return this.cachedColumns;
    }

    public boolean invokeOnComponent(FacesContext context, String clientId, ContextCallback callback) throws FacesException {
        int savedRowIndex = this.getRowIndex();
        try {
            return super.invokeOnComponent(context, clientId, callback);
        }
        catch (Exception e) {
            this.setRowIndex(savedRowIndex);
            return this.invokeOnComponentFromUIComponent(context, clientId, callback);
        }
    }

    public boolean invokeOnComponentFromUIComponent(FacesContext context, String clientId, ContextCallback callback) throws FacesException {
        if (null == context || null == clientId || null == callback) {
            throw new NullPointerException();
        }
        boolean found = false;
        if (clientId.equals(this.getClientId(context))) {
            try {
                this.pushComponentToEL(context, (UIComponent)this);
                callback.invokeContextCallback(context, (UIComponent)this);
                boolean bl = true;
                return bl;
            }
            catch (Exception e) {
                throw new FacesException((Throwable)e);
            }
            finally {
                this.popComponentFromEL(context);
            }
        }
        Iterator itr = this.getFacetsAndChildren();
        while (itr.hasNext() && !found) {
            found = ((UIComponent)itr.next()).invokeOnComponent(context, clientId, callback);
        }
        return found;
    }

    public String getModelUniqueIdentifier() {
        return StringUtils.getNotNullValue(this.getUniqueIdentifier(), this.getId());
    }

    public TableSingleSelectionListener getSingleSelectionListener() {
        return (TableSingleSelectionListener)this.getStateHelper().eval((Serializable)((Object)PROPERTY_SINGLE_SELECTION_LISTENER));
    }

    public void setSingleSelectionListener(TableSingleSelectionListener singleSelectionListener) {
        this.updateStateHelper(PROPERTY_SINGLE_SELECTION_LISTENER, singleSelectionListener);
    }

    public TableModel getModel() {
        return (TableModel)this.getStateHelper().eval((Serializable)((Object)PROPERTY_MODEL));
    }

    public TableRowSortingModel getTableSortModel() {
        TableModel tableModel = this.getModel();
        return tableModel != null ? tableModel.getTableRowSortingModel() : null;
    }

    public TableColumnOrderingModel getTableOrderingModel() {
        TableModel tableModel = this.getModel();
        return tableModel != null ? tableModel.getTableColumnOrderingModel() : null;
    }

    public TableColumnVisibilityModel getTableColumnVisibilityModel() {
        TableModel tableModel = this.getModel();
        return tableModel != null ? tableModel.getTableColumnVisibilityModel() : null;
    }

    public void setModel(TableModel tableModel) {
        this.updateStateHelper(PROPERTY_MODEL, tableModel);
    }

    public String getUniqueIdentifier() {
        return (String)this.getStateHelper().eval((Serializable)((Object)PROPERTY_UNIQUE_IDENTIFIER));
    }

    public void setUniqueIdentifier(String uniqueIdentifier) {
        this.updateStateHelper(PROPERTY_UNIQUE_IDENTIFIER, uniqueIdentifier);
    }

    public boolean isTableCondensed() {
        Object eval = this.getStateHelper().eval((Serializable)((Object)PROPERTY_TABLE_CONDENSED));
        return eval == null ? false : (Boolean)eval;
    }

    public void setTableCondensed(boolean tableCondensed) {
        this.updateStateHelper(PROPERTY_TABLE_CONDENSED, tableCondensed);
    }

    public boolean isTableBordered() {
        Object eval = this.getStateHelper().eval((Serializable)((Object)PROPERTY_TABLE_BORDERED));
        return eval == null ? false : (Boolean)eval;
    }

    public void setTableBordered(boolean tableBordered) {
        this.updateStateHelper(PROPERTY_TABLE_BORDERED, tableBordered);
    }

    public boolean isTableStriped() {
        Object eval = this.getStateHelper().eval((Serializable)((Object)PROPERTY_TABLE_STRIPED));
        return eval == null ? true : (Boolean)eval;
    }

    public void setTableStriped(boolean tableStriped) {
        this.updateStateHelper(PROPERTY_TABLE_STRIPED, tableStriped);
    }

    public String getRowClass() {
        return (String)this.getStateHelper().eval((Serializable)((Object)PROPERTY_TABLE_ROW_CLASS));
    }

    public void setRowClass(String rowClass) {
        this.updateStateHelper(PROPERTY_TABLE_ROW_CLASS, rowClass);
    }

    public boolean isAjaxDisableRenderRegionsOnRequest() {
        Object eval = this.getStateHelper().eval((Serializable)((Object)PROPERTY_AJAX_DISABLE_RENDER_REGION_ON_REQUEST));
        return eval == null ? true : (Boolean)eval;
    }

    public void setAjaxDisableRenderRegionsOnRequest(boolean ajaxDisableRenderRegionsOnRequest) {
        this.updateStateHelper(PROPERTY_AJAX_DISABLE_RENDER_REGION_ON_REQUEST, ajaxDisableRenderRegionsOnRequest);
    }

    private void updateStateHelper(String propertyName, Object value) {
        this.getStateHelper().put((Serializable)((Object)propertyName), value);
        ValueExpression ve = this.getValueExpression(propertyName);
        if (ve != null) {
            ve.setValue(this.getFacesContext().getELContext(), value);
        }
    }
}

