/*
 * Decompiled with CFR 0.152.
 */
package de.larmic.butterfaces.component.renderkit.html_basic.tree;

import de.larmic.butterfaces.component.base.renderer.HtmlBasicRenderer;
import de.larmic.butterfaces.component.html.tree.HtmlTree;
import de.larmic.butterfaces.component.partrenderer.RenderUtils;
import de.larmic.butterfaces.component.partrenderer.StringUtils;
import de.larmic.butterfaces.event.TreeNodeSelectionEvent;
import de.larmic.butterfaces.event.TreeNodeSelectionListener;
import de.larmic.butterfaces.model.tree.Node;
import de.larmic.butterfaces.resolver.WebXmlParameters;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.faces.component.UIComponent;
import javax.faces.component.behavior.ClientBehavior;
import javax.faces.component.behavior.ClientBehaviorContext;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.render.FacesRenderer;

@FacesRenderer(componentFamily="de.larmic.butterfaces.component.family", rendererType="de.larmic.butterfaces.renderkit.html_basic.TreeRenderer")
public class TreeRenderer
extends HtmlBasicRenderer {
    private final Map<String, Node> nodes = new HashMap<String, Node>();
    private Node selectedNode = null;
    private boolean nodeIconsFound = false;
    private WebXmlParameters webXmlParameters;

    public void encodeBegin(FacesContext context, UIComponent component) throws IOException {
        this.rendererParamsNotNull(context, component);
        if (!this.shouldEncode(component)) {
            return;
        }
        HtmlTree htmlTree = (HtmlTree)component;
        ResponseWriter writer = context.getResponseWriter();
        this.webXmlParameters = new WebXmlParameters(context.getExternalContext());
        writer.startElement("div", (UIComponent)htmlTree);
        this.writeIdAttribute(context, writer, component);
        writer.writeAttribute("class", (Object)"butter-component-tree", null);
        ClientBehaviorContext behaviorContext = ClientBehaviorContext.createClientBehaviorContext((FacesContext)context, (UIComponent)htmlTree, (String)"click", (String)component.getClientId(context), null);
        Node root = htmlTree.getValue();
        this.nodeIconsFound = false;
        this.encodeNode(htmlTree, writer, behaviorContext, root, 0, 0, false, !htmlTree.isHideRootNode());
    }

    private void encodeNode(HtmlTree tree, ResponseWriter writer, ClientBehaviorContext behaviorContext, Node node, int depth, int childNumber, boolean collapsed, boolean renderNode) throws IOException {
        if (renderNode) {
            String s;
            String click;
            writer.startElement("ul", (UIComponent)tree);
            writer.startElement("li", (UIComponent)tree);
            if (tree.getNodeSelectionListener() != null && tree.getNodeSelectionListener().isValueSelected(node)) {
                writer.writeAttribute("class", (Object)"butter-component-tree-node-selected", null);
            }
            String nodeNumber = "" + this.nodes.size();
            this.nodes.put(nodeNumber, node);
            if (collapsed) {
                writer.writeAttribute("style", (Object)"display: none;", null);
            }
            writer.startElement("div", (UIComponent)tree);
            writer.writeAttribute("class", (Object)"butter-component-tree-row", null);
            writer.startElement("span", (UIComponent)tree);
            String collapsingClass = node.isCollapsed() ? this.webXmlParameters.getExpansionGlyphicon() : this.webXmlParameters.getCollapsingGlyphicon();
            String nodeClass = node.isLeaf() ? "butter-component-tree-leaf" : "butter-component-tree-node " + collapsingClass;
            writer.writeAttribute("class", (Object)("butter-component-tree-jquery-marker " + nodeClass), null);
            Map behaviors = tree.getClientBehaviors();
            if (behaviors.containsKey("click") && StringUtils.isNotEmpty(click = ((ClientBehavior)((List)behaviors.get("click")).get(0)).getScript(behaviorContext))) {
                s = click.replace(",'click',", ",'collapse_" + nodeNumber + "',");
                writer.writeAttribute("onclick", (Object)s, null);
            }
            writer.endElement("span");
            writer.startElement("span", (UIComponent)tree);
            if (StringUtils.isNotEmpty(node.getImageIcon())) {
                writer.writeAttribute("class", (Object)"butter-component-tree-icon", null);
                writer.writeAttribute("style", (Object)("background-image:url(" + node.getImageIcon() + ")"), null);
                this.nodeIconsFound = true;
            } else if (StringUtils.isNotEmpty(node.getGlyphiconIcon())) {
                writer.writeAttribute("class", (Object)("butter-component-tree-icon " + node.getGlyphiconIcon()), null);
                this.nodeIconsFound = true;
            } else {
                writer.writeAttribute("class", (Object)"butter-component-tree-icon", null);
            }
            writer.endElement("span");
            writer.startElement("span", (UIComponent)tree);
            writer.writeAttribute("id", (Object)(tree.getClientId() + "_" + depth + "_" + childNumber), null);
            writer.writeAttribute("class", (Object)"butter-component-tree-title", null);
            if (behaviors.containsKey("click") && StringUtils.isNotEmpty(click = ((ClientBehavior)((List)behaviors.get("click")).get(0)).getScript(behaviorContext))) {
                s = click.replace(",'click',", ",'click_" + nodeNumber + "',");
                String jQueryPluginCall = RenderUtils.createJQueryPluginCall(tree.getClientId(), "selectTreeNode({nodeNumber:'" + nodeNumber + "'})");
                writer.writeAttribute("onclick", (Object)(s + ";" + jQueryPluginCall), null);
                writer.writeAttribute("treenode", (Object)nodeNumber, null);
            }
            writer.writeText((Object)node.getTitle(), null);
            writer.endElement("span");
            writer.endElement("div");
        }
        if (!node.isLeaf()) {
            List<Node> subNodes = node.getSubNodes();
            int i = 0;
            for (Node subNode : subNodes) {
                this.encodeNode(tree, writer, behaviorContext, subNode, depth + 1, i++, this.isCollapsed(node) || collapsed, true);
            }
        }
        if (renderNode) {
            writer.endElement("li");
            writer.endElement("ul");
        }
    }

    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        this.rendererParamsNotNull(context, component);
        if (!this.shouldEncode(component)) {
            return;
        }
        HtmlTree htmlTree = (HtmlTree)component;
        ResponseWriter writer = context.getResponseWriter();
        String pluginFunctionCall = "butterTree(" + this.createButterTreeJQueryParameter(htmlTree) + ")";
        RenderUtils.renderJQueryPluginCall(htmlTree.getClientId(), pluginFunctionCall, writer, component);
        writer.endElement("div");
    }

    public void decode(FacesContext context, UIComponent component) {
        HtmlTree htmlTree = (HtmlTree)component;
        TreeNodeSelectionListener nodeSelectionListener = htmlTree.getNodeSelectionListener();
        Map behaviors = htmlTree.getClientBehaviors();
        if (nodeSelectionListener == null) {
            return;
        }
        if (behaviors.isEmpty()) {
            return;
        }
        ExternalContext external = context.getExternalContext();
        Map params = external.getRequestParameterMap();
        String behaviorEvent = (String)params.get("javax.faces.behavior.event");
        if (behaviorEvent != null && behaviorEvent.contains("_")) {
            String[] split = behaviorEvent.split("_");
            String event = split[0];
            String nodeNumber = split[1];
            Node node = this.nodes.get(nodeNumber);
            if (node != null) {
                if ("click".equals(event)) {
                    nodeSelectionListener.processValueChange(new TreeNodeSelectionEvent(this.selectedNode, node));
                    this.selectedNode = node;
                } else if ("collapse".equals(event)) {
                    node.setCollapsed(!node.isCollapsed());
                }
            }
        }
    }

    private String createButterTreeJQueryParameter(HtmlTree htmlTree) {
        Map behaviors = htmlTree.getClientBehaviors();
        boolean treeIconsEnabled = behaviors.containsKey("click");
        return "{expansionClass: '" + this.webXmlParameters.getExpansionGlyphicon() + "', collapsingClass: '" + this.webXmlParameters.getCollapsingGlyphicon() + "', treeSelectionEnabled: '" + treeIconsEnabled + "', treeIconsEnabled: '" + this.nodeIconsFound + "'}";
    }

    private boolean isCollapsed(Node node) {
        return !node.getSubNodes().isEmpty() && node.isCollapsed();
    }
}

