/*
 * Decompiled with CFR 0.152.
 */
package de.larmic.butterfaces.event;

import de.larmic.butterfaces.event.ResourceComparator;
import de.larmic.butterfaces.resolver.WebXmlParameters;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.faces.component.UIComponent;
import javax.faces.component.UIOutput;
import javax.faces.component.UIViewRoot;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.faces.event.AbortProcessingException;
import javax.faces.event.SystemEvent;
import javax.faces.event.SystemEventListener;

public class HandleResourceListener
implements SystemEventListener {
    private static final String HEAD = "head";
    private static final String CONFIGURABLE_LIBRARY_NAME = "butterfaces-configurable";
    public static final String JQUERY_PREFIX_RESOURCE_IDENTIFIER = "jquery";
    public static final String BOOTSTRAP_PREFIX_RESOURCE_IDENTIFIER = "bootstrap";
    public static final String PRETTYPRINT_PREFIX_RESOURCE_IDENTIFIER = "prettify";

    public boolean isListenerForSource(Object source) {
        return source instanceof UIViewRoot;
    }

    public void processEvent(SystemEvent event) throws AbortProcessingException {
        FacesContext context = FacesContext.getCurrentInstance();
        WebXmlParameters webXmlParameters = new WebXmlParameters(context.getExternalContext());
        boolean provideJQuery = webXmlParameters.isProvideJQuery();
        boolean provideBootstrap = webXmlParameters.isProvideBoostrap();
        boolean providePrettyPrint = webXmlParameters.isProvidePrettyprint();
        boolean useCompressedResources = webXmlParameters.isUseCompressedResources();
        boolean localhost = "localhost".equals(context.getExternalContext().getRequestServerName());
        ArrayList<UIComponent> resources = new ArrayList<UIComponent>(context.getViewRoot().getComponentResources(context, HEAD));
        if (useCompressedResources && !localhost) {
            this.handleCompressedResources(context, provideJQuery, provideBootstrap, providePrettyPrint, resources);
        } else {
            this.handleSingleResources(context, provideJQuery, provideBootstrap, providePrettyPrint, resources);
        }
    }

    private void handleCompressedResources(FacesContext context, boolean provideJQuery, boolean provideBootstrap, boolean providePrettyPrint, List<UIComponent> resources) {
        for (UIComponent resource : resources) {
            String resourceLibrary = (String)resource.getAttributes().get("library");
            String resourceName = (String)resource.getAttributes().get("name");
            if (resourceLibrary.startsWith(CONFIGURABLE_LIBRARY_NAME)) {
                boolean handlePrettyPrintResource = providePrettyPrint && (!provideJQuery || !provideBootstrap);
                boolean ignorePrettyPringResource = handlePrettyPrintResource && resourceName.startsWith(PRETTYPRINT_PREFIX_RESOURCE_IDENTIFIER);
                boolean handleBootStrapResource = provideBootstrap && !provideJQuery;
                boolean ignoreBootStrapResource = handleBootStrapResource && resourceName.startsWith(BOOTSTRAP_PREFIX_RESOURCE_IDENTIFIER);
                boolean ignoreResourceRemoval = ignorePrettyPringResource || ignoreBootStrapResource;
                if (ignoreResourceRemoval) continue;
                this.removeHeadResource(context, resource);
                continue;
            }
            if (!resourceLibrary.startsWith("butterfaces")) continue;
            this.removeHeadResource(context, resource);
        }
        if (provideBootstrap && provideJQuery && providePrettyPrint) {
            this.addGeneratedCSSResource(context, "butterfaces-all.min.css");
            this.addGeneratedJSResource(context, "butterfaces-all.min.js");
        } else if (provideJQuery && provideBootstrap) {
            this.addGeneratedCSSResource(context, "butterfaces-jquery-bootstrap.min.css");
            this.addGeneratedJSResource(context, "butterfaces-jquery-bootstrap.min.js");
        } else if (provideJQuery) {
            this.addGeneratedCSSResource(context, "butterfaces-jquery.min.css");
            this.addGeneratedJSResource(context, "butterfaces-jquery.min.js");
        } else {
            this.addGeneratedCSSResource(context, "butterfaces-only.min.css");
            this.addGeneratedJSResource(context, "butterfaces-only.min.js");
        }
    }

    private void handleSingleResources(FacesContext context, boolean provideJQuery, boolean provideBootstrap, boolean providePrettyPrint, List<UIComponent> resources) {
        this.removeAllResourcesFromViewRoot(context, resources);
        Collections.sort(resources, new ResourceComparator());
        this.addResourcesToViewRoot(context, provideJQuery, provideBootstrap, providePrettyPrint, resources);
    }

    private void removeAllResourcesFromViewRoot(FacesContext context, List<UIComponent> resources) {
        for (UIComponent resource : resources) {
            this.removeHeadResource(context, resource);
        }
    }

    private void addResourcesToViewRoot(FacesContext context, boolean provideJQuery, boolean provideBootstrap, boolean providePrettyPrint, List<UIComponent> resources) {
        for (UIComponent resource : resources) {
            String resourceLibrary = (String)resource.getAttributes().get("library");
            String resourceName = (String)resource.getAttributes().get("name");
            boolean isResourceAccepted = true;
            if (CONFIGURABLE_LIBRARY_NAME.equals(resourceLibrary)) {
                if (!provideJQuery && resourceName.startsWith(JQUERY_PREFIX_RESOURCE_IDENTIFIER)) {
                    isResourceAccepted = false;
                } else if (!provideBootstrap && resourceName.startsWith(BOOTSTRAP_PREFIX_RESOURCE_IDENTIFIER)) {
                    isResourceAccepted = false;
                } else if (!providePrettyPrint && resourceName.startsWith(PRETTYPRINT_PREFIX_RESOURCE_IDENTIFIER)) {
                    isResourceAccepted = false;
                }
            }
            if (!isResourceAccepted) continue;
            context.getViewRoot().addComponentResource(context, resource, HEAD);
        }
    }

    private void addGeneratedJSResource(FacesContext context, String resourceName) {
        UIOutput resource = new UIOutput();
        resource.getAttributes().put("name", resourceName);
        resource.setRendererType("javax.faces.resource.Script");
        resource.getAttributes().put("library", "butterfaces-generated");
        context.getViewRoot().addComponentResource(context, (UIComponent)resource, HEAD);
    }

    private void addGeneratedCSSResource(FacesContext context, String resourceName) {
        UIOutput resource = new UIOutput();
        resource.getAttributes().put("name", resourceName);
        resource.setRendererType("javax.faces.resource.Stylesheet");
        resource.getAttributes().put("library", "butterfaces-generated");
        context.getViewRoot().addComponentResource(context, (UIComponent)resource, HEAD);
    }

    private boolean readContextParameter(ExternalContext externalContext, String contextParameterName) {
        String provideJQueryParam = externalContext.getInitParameter(contextParameterName);
        return Boolean.parseBoolean(provideJQueryParam == null ? Boolean.TRUE.toString() : provideJQueryParam);
    }

    private void removeHeadResource(FacesContext context, UIComponent resource) {
        context.getViewRoot().removeComponentResource(context, resource, HEAD);
    }
}

