/*
 * Decompiled with CFR 0.152.
 */
package de.larmic.butterfaces.model.json;

import de.larmic.butterfaces.model.json.Ordering;
import de.larmic.butterfaces.model.table.TableColumnOrdering;
import de.larmic.butterfaces.model.table.TableColumnVisibility;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;

public class JsonToModelConverter {
    public TableColumnVisibility convertTableColumnVisibility(String tableIdentifier, String json) {
        String[] split = this.pitColumns(json);
        ArrayList<String> visibleColumns = new ArrayList<String>();
        ArrayList<String> invisibleColumns = new ArrayList<String>();
        for (String column : split) {
            String[] attribute = this.pitAttributes(column);
            String identifier = attribute[0].split(":")[1];
            String visible = attribute[1].split(":")[1];
            if (Boolean.valueOf(visible).booleanValue()) {
                visibleColumns.add(identifier);
                continue;
            }
            invisibleColumns.add(identifier);
        }
        return new TableColumnVisibility(tableIdentifier, visibleColumns, invisibleColumns);
    }

    public TableColumnOrdering convertTableColumnOrdering(String tableIdentifier, String json) {
        String[] split = this.pitColumns(json);
        ArrayList<Ordering> orderings = new ArrayList<Ordering>();
        for (String column : split) {
            String[] attribute = this.pitAttributes(column);
            String identifier = attribute[0].split(":")[1];
            String position = attribute[1].split(":")[1];
            orderings.add(new Ordering(identifier, Integer.valueOf(position)));
        }
        Collections.sort(orderings, new Comparator<Ordering>(){

            @Override
            public int compare(Ordering o1, Ordering o2) {
                return o1.getIndex().compareTo(o2.getIndex());
            }
        });
        ArrayList<String> columnIdentifier = new ArrayList<String>();
        for (Ordering ordering : orderings) {
            columnIdentifier.add(ordering.getIdentifier());
        }
        return new TableColumnOrdering(tableIdentifier, columnIdentifier);
    }

    private String[] pitColumns(String json) {
        return json.trim().split("(?<=\\}),(?=\\{)");
    }

    private String[] pitAttributes(String column) {
        String cleanedColumn = column.replace("{", "");
        cleanedColumn = cleanedColumn.replace("[", "");
        cleanedColumn = cleanedColumn.replace("}", "");
        cleanedColumn = cleanedColumn.replace("]", "");
        cleanedColumn = cleanedColumn.replace("\"", "");
        return cleanedColumn.split(",");
    }
}

