/*
 * Decompiled with CFR 0.152.
 */
package de.larmic.butterfaces.resolver;

import de.larmic.butterfaces.component.partrenderer.StringUtils;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.faces.component.UIComponentBase;
import javax.faces.component.behavior.AjaxBehavior;
import javax.faces.component.behavior.ClientBehavior;

public class AjaxRequest {
    private final List<String> renderIds;
    private final UIComponentBase component;
    private final String onevent;
    private final String eventName;

    public AjaxRequest(UIComponentBase component, String event) {
        this(component, event, null);
    }

    public AjaxRequest(UIComponentBase component, String event, String onEvent) {
        this.renderIds = this.createRefreshIds(component, event);
        this.component = component;
        this.onevent = onEvent;
        this.eventName = event;
    }

    public String createJavaScriptCall() {
        return this.createJavaScriptCall(this.eventName);
    }

    public String createJavaScriptCall(String customEventName) {
        return this.createJavaScriptCall(customEventName, this.onevent);
    }

    public String createJavaScriptCall(String customEventName, String customOnEvent) {
        String render = this.createRender(this.renderIds);
        if (StringUtils.isEmpty(customOnEvent)) {
            return "jsf.ajax.request('" + this.component.getClientId() + "','" + customEventName + "',{" + this.createRenderPart(render) + "'javax.faces.behavior.event':'" + customEventName + "'});";
        }
        return "jsf.ajax.request('" + this.component.getClientId() + "','" + customEventName + "',{" + this.createRenderPart(render) + "onevent: " + customOnEvent + ", 'javax.faces.behavior.event':'" + customEventName + "'});";
    }

    public String createJavaScriptCall(String customEventName, boolean disableElements) {
        if (disableElements && !this.renderIds.isEmpty()) {
            StringBuilder onEvent = new StringBuilder("(function(data) { butter.ajax.disableElementsOnRequest(data, [");
            Iterator<String> iterator = this.renderIds.iterator();
            while (iterator.hasNext()) {
                String renderId = iterator.next();
                onEvent.append("'");
                onEvent.append(renderId);
                onEvent.append("'");
                if (!iterator.hasNext()) continue;
                onEvent.append(", ");
            }
            onEvent.append("]) })");
            return this.createJavaScriptCall(customEventName, onEvent.toString());
        }
        return this.createJavaScriptCall(customEventName, null);
    }

    private String createRenderPart(String render) {
        if (StringUtils.isNotEmpty(render)) {
            return "render: '" + render + "', ";
        }
        return "";
    }

    public List<String> getRenderIds() {
        return this.renderIds;
    }

    private String createRender(List<String> additionalRenderIds) {
        StringBuilder render = new StringBuilder();
        if (!additionalRenderIds.isEmpty()) {
            Iterator<String> iterator = additionalRenderIds.iterator();
            while (iterator.hasNext()) {
                render.append(iterator.next());
                if (!iterator.hasNext()) continue;
                render.append(" ");
            }
        }
        return render.toString();
    }

    private List<String> createRefreshIds(UIComponentBase component, String eventName) {
        ArrayList<String> idsToRender = new ArrayList<String>();
        Map behaviors = component.getClientBehaviors();
        List refreshBehaviors = (List)behaviors.get(eventName);
        if (refreshBehaviors == null) {
            throw new IllegalArgumentException("Ajax event '" + eventName + "' not found on component '" + component.getClientId() + "'.");
        }
        boolean enabledAjaxEventFound = false;
        if (!refreshBehaviors.isEmpty()) {
            for (ClientBehavior refreshBehavior : refreshBehaviors) {
                AjaxBehavior ajaxBehavior;
                if (!(refreshBehavior instanceof AjaxBehavior) || (ajaxBehavior = (AjaxBehavior)refreshBehavior).isDisabled()) continue;
                if (ajaxBehavior.getRender() != null && !ajaxBehavior.getRender().isEmpty()) {
                    for (String singleRender : ajaxBehavior.getRender()) {
                        idsToRender.add(singleRender);
                    }
                }
                enabledAjaxEventFound = true;
            }
        }
        if (!enabledAjaxEventFound) {
            throw new IllegalStateException("Ajax event '" + eventName + "' on component '" + component.getClientId() + "' is disabled.");
        }
        return idsToRender;
    }
}

