/*
 * Decompiled with CFR 0.152.
 */
package de.skuzzle.enforcer.restrictimports.analyze;

import de.skuzzle.enforcer.restrictimports.analyze.BannedImportGroup;
import de.skuzzle.enforcer.restrictimports.analyze.BannedImportGroups;
import de.skuzzle.enforcer.restrictimports.analyze.MatchedFile;
import de.skuzzle.enforcer.restrictimports.analyze.MatchedImport;
import de.skuzzle.enforcer.restrictimports.analyze.PackagePattern;
import de.skuzzle.enforcer.restrictimports.analyze.Warning;
import de.skuzzle.enforcer.restrictimports.parser.Annotation;
import de.skuzzle.enforcer.restrictimports.parser.ImportStatement;
import de.skuzzle.enforcer.restrictimports.parser.ParsedFile;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ImportAnalyzer {
    private static final Logger LOGGER = LoggerFactory.getLogger(ImportAnalyzer.class);

    ImportAnalyzer() {
    }

    Optional<MatchedFile> matchFile(ParsedFile sourceFile, BannedImportGroups groups) {
        LOGGER.trace("Analyzing {} for banned imports", (Object)sourceFile);
        List<Warning> warnings = this.warningsFrom(sourceFile);
        if (sourceFile.isFailedToParse()) {
            LOGGER.trace("Skipping analysis because source file failed to parse: {}", (Object)sourceFile);
            return Optional.of(MatchedFile.forSourceFile(sourceFile.getPath()).withFailedToParse(true).withWarnings(warnings).build());
        }
        BannedImportGroup group = groups.selectGroupFor(sourceFile.getFqcn()).orElse(null);
        if (group == null) {
            if (!warnings.isEmpty()) {
                LOGGER.trace("No rule group matched {}, but warnings were found: {}", (Object)sourceFile, (Object)warnings);
                return Optional.of(MatchedFile.forSourceFile(sourceFile.getPath()).withWarnings(warnings).build());
            }
            LOGGER.trace("No rule group matched {}", (Object)sourceFile);
            return Optional.empty();
        }
        LOGGER.trace("Selected {} for {}", (Object)group, (Object)sourceFile);
        ArrayList<MatchedImport> matches = new ArrayList<MatchedImport>();
        for (ImportStatement importStmt : sourceFile.getImports()) {
            group.ifImportIsBanned(sourceFile.getFqcn(), importStmt.getImportName()).map(bannedImport -> new MatchedImport(importStmt.getLine(), importStmt.getImportName(), (PackagePattern)bannedImport)).ifPresent(matches::add);
        }
        if (matches.isEmpty() && warnings.isEmpty()) {
            return Optional.empty();
        }
        MatchedFile matchedFile = new MatchedFile(sourceFile.getPath(), matches, group, warnings, false);
        LOGGER.debug("Found banned import matches or warnings: {}", (Object)matchedFile);
        return Optional.of(matchedFile);
    }

    private List<Warning> warningsFrom(ParsedFile sourceFile) {
        return sourceFile.getAnnotations().stream().map(Annotation::getMessage).map(Warning::withMessage).collect(Collectors.toList());
    }
}

