/*
 * Decompiled with CFR 0.152.
 */
package de.skuzzle.enforcer.restrictimports.analyze;

import de.skuzzle.enforcer.restrictimports.analyze.BannedImportGroup;
import de.skuzzle.enforcer.restrictimports.analyze.MatchedImport;
import de.skuzzle.enforcer.restrictimports.analyze.PackagePattern;
import de.skuzzle.enforcer.restrictimports.analyze.Warning;
import de.skuzzle.enforcer.restrictimports.util.Preconditions;
import de.skuzzle.enforcer.restrictimports.util.StringRepresentation;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public final class MatchedFile {
    private final Path sourceFile;
    private final List<MatchedImport> matchedImports;
    private final BannedImportGroup matchedBy;
    private final List<Warning> warnings;
    private final boolean failedToParse;

    MatchedFile(Path sourceFile, List<MatchedImport> matchedImports, BannedImportGroup matchedBy, List<Warning> warnings, boolean failedToParse) {
        this.sourceFile = sourceFile;
        this.matchedImports = matchedImports;
        this.matchedBy = matchedBy;
        this.warnings = warnings;
        this.failedToParse = failedToParse;
    }

    public static Builder forSourceFile(Path sourceFile) {
        return new Builder(sourceFile);
    }

    public Path getSourceFile() {
        return this.sourceFile;
    }

    public List<MatchedImport> getMatchedImports() {
        return this.matchedImports;
    }

    public Optional<BannedImportGroup> getMatchedBy() {
        return Optional.ofNullable(this.matchedBy);
    }

    public boolean isFailedToParse() {
        return this.failedToParse;
    }

    public List<Warning> getWarnings() {
        return this.warnings;
    }

    public boolean hasWarning() {
        return !this.warnings.isEmpty();
    }

    public boolean hasBannedImports() {
        return !this.matchedImports.isEmpty();
    }

    public int hashCode() {
        return Objects.hash(this.sourceFile, this.matchedImports, this.matchedBy, this.warnings, this.failedToParse);
    }

    public boolean equals(Object obj) {
        return obj == this || obj instanceof MatchedFile && Objects.equals(this.sourceFile, ((MatchedFile)obj).sourceFile) && Objects.equals(this.matchedImports, ((MatchedFile)obj).matchedImports) && Objects.equals(this.matchedBy, ((MatchedFile)obj).matchedBy) && Objects.equals(this.warnings, ((MatchedFile)obj).warnings) && this.failedToParse == ((MatchedFile)obj).failedToParse;
    }

    public String toString() {
        return StringRepresentation.ofInstance(this).add("sourceFile", this.sourceFile).add("matchedImports", this.matchedImports).add("matchedBy", this.matchedBy).add("warnings", this.warnings).add("failedToParse", this.failedToParse).toString();
    }

    public static class Builder {
        private final Path sourceFile;
        private final List<MatchedImport> matchedImports = new ArrayList<MatchedImport>();
        private BannedImportGroup matchedBy;
        private boolean failedToParse;
        private final List<Warning> warnings = new ArrayList<Warning>();

        private Builder(Path sourceFile) {
            Preconditions.checkArgument(sourceFile != null, "sourceFile must not be null", new Object[0]);
            this.sourceFile = sourceFile;
        }

        public Builder withMatchAt(int importLine, String matchedString, PackagePattern matchedBy) {
            this.matchedImports.add(new MatchedImport(importLine, matchedString, matchedBy));
            return this;
        }

        public Builder matchedBy(BannedImportGroup group) {
            this.matchedBy = group;
            return this;
        }

        public Builder withWarnings(Warning ... warnings) {
            return this.withWarnings(Arrays.asList(warnings));
        }

        public Builder withWarnings(List<Warning> warnings) {
            this.warnings.addAll(warnings);
            return this;
        }

        public Builder withFailedToParse(boolean failedToParse) {
            this.failedToParse = failedToParse;
            return this;
        }

        public MatchedFile build() {
            return new MatchedFile(this.sourceFile, this.matchedImports, this.matchedBy, this.warnings, this.failedToParse);
        }
    }
}

