/*
 * Decompiled with CFR 0.152.
 */
package de.skuzzle.enforcer.restrictimports.parser;

import de.skuzzle.enforcer.restrictimports.parser.Annotation;
import de.skuzzle.enforcer.restrictimports.parser.ImportStatement;
import de.skuzzle.enforcer.restrictimports.parser.ImportStatementParser;
import de.skuzzle.enforcer.restrictimports.parser.LineSupplier;
import de.skuzzle.enforcer.restrictimports.parser.ParsedFile;
import de.skuzzle.enforcer.restrictimports.parser.SkipCommentsLineSupplier;
import de.skuzzle.enforcer.restrictimports.parser.lang.LanguageSupport;
import de.skuzzle.enforcer.restrictimports.util.Preconditions;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class ImportStatementParserImpl
implements ImportStatementParser {
    private static final Logger LOGGER = LoggerFactory.getLogger(ImportStatementParserImpl.class);
    private final LineSupplier supplier;
    private final Charset charset;
    private final boolean parseFullCompilationUnit;

    ImportStatementParserImpl(Charset charset, boolean parseFullCompilationUnit) {
        this.supplier = new SkipCommentsLineSupplier(charset);
        this.charset = charset;
        this.parseFullCompilationUnit = parseFullCompilationUnit;
    }

    @Override
    public ParsedFile parse(Path sourceFilePath) {
        LOGGER.trace("Analyzing {} for imports", (Object)sourceFilePath);
        LanguageSupport languageSupport = LanguageSupport.getLanguageSupport(sourceFilePath);
        try {
            if (this.parseFullCompilationUnit && languageSupport.parseFullCompilationUnitSupported()) {
                LOGGER.debug("Using 'full-compilation-unit' parsing for {}", (Object)sourceFilePath);
                return this.parseCompilationUnit(sourceFilePath, languageSupport);
            }
            LOGGER.debug("Using 'line-based' parsing for {}", (Object)sourceFilePath);
            return this.parseLineByLine(sourceFilePath, languageSupport);
        }
        catch (IOException e) {
            LOGGER.debug("Encountered IOException while analyzing {} for banned imports", (Object)sourceFilePath, (Object)e);
            return ParsedFile.failedToParse(sourceFilePath, Annotation.withMessage("Encountered IOException while parsing"));
        }
    }

    private ParsedFile parseCompilationUnit(Path sourceFilePath, LanguageSupport languageSupport) throws IOException {
        try {
            return languageSupport.parseCompilationUnit(sourceFilePath, this.charset);
        }
        catch (Exception e) {
            LOGGER.debug("Full compilation unit parsing of {} resulted in failure. Falling back to line-by-line parsing", (Object)sourceFilePath, (Object)e);
            return this.parseLineByLine(sourceFilePath, languageSupport).andAddAnnotation(Annotation.withMessage("Failed to parse in full-compilation-unit mode. Analysis might be inaccurate"));
        }
    }

    private ParsedFile parseLineByLine(Path sourceFilePath, LanguageSupport languageSupport) throws IOException {
        ArrayList<ImportStatement> imports = new ArrayList<ImportStatement>();
        String fileName = this.getFileNameWithoutExtension(sourceFilePath);
        try (Stream<String> lines = this.supplier.lines(sourceFilePath);){
            int row = 1;
            String packageName = "";
            String fqcn = fileName;
            Iterator it = lines.map(String::trim).iterator();
            while (it.hasNext()) {
                String line = (String)it.next();
                if (!line.isEmpty()) {
                    Optional<String> packageDeclaration = languageSupport.parsePackage(line);
                    if (packageDeclaration.isPresent()) {
                        Preconditions.checkState(packageName.isEmpty(), "found duplicate package statement in '%s'", sourceFilePath);
                        packageName = packageDeclaration.get();
                        fqcn = this.guessFQCN(packageName, fileName);
                        LOGGER.trace("Guessed full qualified class name from {} and {}: '{}'", packageName, fileName, fqcn);
                    } else {
                        List<ImportStatement> importStatements = languageSupport.parseImport(line, row);
                        if (importStatements.isEmpty()) break;
                        imports.addAll(importStatements);
                    }
                }
                ++row;
            }
            ParsedFile parsedFile = ParsedFile.successful(sourceFilePath, packageName, fqcn, imports);
            return parsedFile;
        }
    }

    private String guessFQCN(String packageName, String sourceFileName) {
        return packageName.isEmpty() ? sourceFileName : packageName + "." + sourceFileName;
    }

    private String getFileNameWithoutExtension(Path file) {
        String s = file.getFileName().toString();
        int i = s.lastIndexOf(".");
        return s.substring(0, i);
    }
}

