/*
 * Decompiled with CFR 0.152.
 */
package de.skuzzle.enforcer.restrictimports.parser;

import java.io.IOException;
import java.io.Reader;
import java.util.ArrayDeque;
import java.util.Deque;

class TransientCommentReader
extends Reader {
    private boolean eos = false;
    private final boolean trackLineBreaks;
    private final Reader in;
    private final Deque<Integer> pushbackBuffer = new ArrayDeque<Integer>(128);

    protected TransientCommentReader(Reader in, boolean trackLineBreaks) {
        this.in = in;
        this.trackLineBreaks = trackLineBreaks;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int read(char[] cbuf, int off, int len) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            int i;
            if (len <= 0) {
                if (len < 0) {
                    throw new IndexOutOfBoundsException();
                }
                if (off < 0 || off > cbuf.length) {
                    throw new IndexOutOfBoundsException();
                }
                return 0;
            }
            for (i = 0; i < len; ++i) {
                int next = this.read();
                if (next == -1) {
                    return i == 0 ? -1 : i;
                }
                cbuf[i + off] = (char)next;
            }
            return i;
        }
    }

    @Override
    public int read() throws IOException {
        if (this.eos) {
            return -1;
        }
        return this.commentRead();
    }

    private int commentRead() throws IOException {
        int next = this.saveRead();
        switch (next) {
            case 47: {
                next = this.saveRead();
                switch (next) {
                    case 42: {
                        return this.skipBlockComment();
                    }
                    case 47: {
                        return this.skipInlineComment();
                    }
                }
                this.saveUnread(next);
                return 47;
            }
        }
        return next;
    }

    private int skipBlockComment() throws IOException {
        int skippedLines = 0;
        while (!this.eos) {
            int next = this.saveRead();
            if (next == 13) {
                ++skippedLines;
                next = this.saveRead();
                if (next == 10) {
                    continue;
                }
            } else if (next == 10) {
                ++skippedLines;
                continue;
            }
            if (next != 42) continue;
            next = this.saveRead();
            if (next == 47) {
                if (this.trackLineBreaks) {
                    for (int i = 0; i < skippedLines; ++i) {
                        this.saveUnread(10);
                    }
                }
                return this.read();
            }
            this.saveUnread(next);
        }
        return -1;
    }

    private int skipInlineComment() throws IOException {
        while (!this.eos) {
            int next = this.saveRead();
            if (next != 13 && next != 10) continue;
            return next;
        }
        return -1;
    }

    private int saveRead() throws IOException {
        if (this.eos) {
            return -1;
        }
        Integer next = this.pushbackBuffer.poll();
        next = next == null ? this.in.read() : next.intValue();
        this.eos = next == -1;
        return next;
    }

    private void saveUnread(int c) throws IOException {
        if (c == -1) {
            this.eos = true;
        } else {
            this.pushbackBuffer.addFirst(c);
        }
    }

    @Override
    public void close() throws IOException {
        this.in.close();
    }
}

