/*
 * Decompiled with CFR 0.152.
 */
package de.triology.recaptchav2java;

import de.triology.recaptchav2java.ReCaptchaException;
import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class Http {
    private static final Logger LOG = LoggerFactory.getLogger(Http.class);

    private Http() {
    }

    static String post(String url, String urlParameters) {
        return Http.withConnectionTo(url, connection -> {
            Http.sendPostRequest(connection, urlParameters);
            return Http.receiveResponse(connection);
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String withConnectionTo(String url, Function<HttpURLConnection, String> runnable) {
        HttpURLConnection con = null;
        try {
            LOG.trace("Opening connection to {}", (Object)url);
            con = Http.openConnection(url);
            String string = runnable.apply(con);
            return string;
        }
        finally {
            if (con != null) {
                LOG.trace("Closing connection to {}", (Object)url);
                con.disconnect();
            }
        }
    }

    private static HttpURLConnection openConnection(String url) {
        try {
            return (HttpURLConnection)new URL(url).openConnection();
        }
        catch (IOException e) {
            throw new ReCaptchaException("Unable to create URL for posting", e);
        }
    }

    private static void sendPostRequest(HttpURLConnection con, String bodyParams) {
        try {
            Http.sendPostRequestWithExceptions(con, bodyParams);
        }
        catch (IOException e) {
            throw new ReCaptchaException("I/O error while sending the POST request", e);
        }
    }

    private static void sendPostRequestWithExceptions(HttpURLConnection con, String parameters) throws IOException {
        con.setRequestMethod("POST");
        con.setDoOutput(true);
        LOG.trace("Posting parameters {} to url {}", (Object)parameters, (Object)con.getURL());
        try (DataOutputStream wr = new DataOutputStream(con.getOutputStream());){
            wr.writeBytes(parameters);
            wr.flush();
        }
    }

    private static String receiveResponse(HttpURLConnection con) {
        try {
            return Http.receiveResponseWithExceptions(con);
        }
        catch (IOException e) {
            throw new ReCaptchaException("I/O error receiving the response ", e);
        }
    }

    private static String receiveResponseWithExceptions(HttpURLConnection con) throws IOException {
        try (BufferedReader in = new BufferedReader(new InputStreamReader(con.getInputStream()));){
            LOG.trace("Receiving response from {}. Status Code: {}", (Object)con.getURL(), (Object)con.getResponseCode());
            String response = Http.toString(in);
            LOG.trace("Received response from {}: {}", (Object)con.getURL(), (Object)response);
            String string = response;
            return string;
        }
    }

    private static String toString(BufferedReader in) throws IOException {
        String inputLine;
        StringBuilder response = new StringBuilder();
        while ((inputLine = in.readLine()) != null) {
            response.append(inputLine);
        }
        return response.toString();
    }
}

