/*
 * Decompiled with CFR 0.152.
 */
package de.triology.recaptchav2java;

import com.google.common.annotations.VisibleForTesting;
import de.triology.recaptchav2java.Http;
import de.triology.recaptchav2java.ReCaptchaJson;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ReCaptchaEndPoint {
    private static final Logger LOG = LoggerFactory.getLogger(ReCaptchaEndPoint.class);
    @VisibleForTesting
    static final String URL_PROTOCOL_HOST = "https://www.google.com";
    @VisibleForTesting
    static final String URL_QUERY_PART = "/recaptcha/api/siteverify";
    private static final String URL_ABSOLUTE = "https://www.google.com/recaptcha/api/siteverify";
    private static final String POST_PARAM_SECRET = "secret";
    private static final String POST_PARAM_TOKEN = "response";
    private final String secret;

    ReCaptchaEndPoint(String secret) {
        this.secret = secret;
    }

    boolean verify(String token) {
        LOG.debug("Verifying token {}", (Object)token);
        String response = Http.post(this.getAbsoluteUrl(), this.createUrlParameters(token));
        boolean success = new ReCaptchaJson(response).isSuccess();
        LOG.debug("Received response for token {}: success={}", (Object)token, (Object)success);
        return success;
    }

    private String createUrlParameters(String token) {
        return "secret=" + this.secret + "&" + POST_PARAM_TOKEN + "=" + token;
    }

    @VisibleForTesting
    protected String getAbsoluteUrl() {
        return URL_ABSOLUTE;
    }
}

