/*
 * Decompiled with CFR 0.152.
 */
package de.tum.in.test.api.internal;

import de.tum.in.test.api.ActivateHiddenBefore;
import de.tum.in.test.api.Deadline;
import de.tum.in.test.api.ExtendedDeadline;
import de.tum.in.test.api.internal.TestContext;
import de.tum.in.test.api.internal.TestType;
import de.tum.in.test.api.localization.Messages;
import java.lang.annotation.Annotation;
import java.lang.annotation.AnnotationFormatError;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.time.Duration;
import java.time.LocalDateTime;
import java.time.format.DateTimeParseException;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apiguardian.api.API;
import org.junit.jupiter.api.Assertions;
import org.junit.platform.commons.support.AnnotationSupport;

@API(status=API.Status.INTERNAL)
public final class TestGuardUtils {
    private static final Pattern DURATION_PATTERN = Pattern.compile("(?:(?<d>\\d+)d)?\\s*(?:\\b(?<h>\\d+)h)?\\s*(?:\\b(?<m>\\d+)m)?", 2);

    private TestGuardUtils() {
    }

    public static void checkForHidden(TestContext context) {
        if (TestGuardUtils.hasAnnotationType(context, TestType.HIDDEN)) {
            LocalDateTime finalDeadline;
            if (TestGuardUtils.hasAnnotationType(context, TestType.PUBLIC)) {
                throw new AnnotationFormatError(Messages.formatLocalized("test_guard.test_cannot_be_public_and_hidden", context.displayName()));
            }
            LocalDateTime now = LocalDateTime.now();
            if (now.isAfter(finalDeadline = TestGuardUtils.extractDeadline(context))) {
                return;
            }
            Optional<LocalDateTime> activationBefore = TestGuardUtils.extractActivationBefore(context);
            if (activationBefore.map(now::isBefore).orElse(false).booleanValue()) {
                return;
            }
            Assertions.fail((String)Messages.localized("test_guard.hidden_test_before_deadline_message"));
        } else if (TestGuardUtils.hasAnnotation(context, Deadline.class) || TestGuardUtils.hasAnnotation(context, ExtendedDeadline.class)) {
            throw new AnnotationFormatError(Messages.formatLocalized("test_guard.public_test_cannot_have_deadline", context.displayName()));
        }
    }

    public static boolean hasAnnotation(TestContext context, Class<? extends Annotation> type) {
        Optional<Method> element = context.testMethod();
        return AnnotationSupport.findAnnotation(element, type).isPresent();
    }

    public static boolean hasAnnotationType(TestContext context, TestType type) {
        return context.findTestType().orElse(null) == type;
    }

    public static LocalDateTime extractDeadline(TestContext context) {
        Optional<LocalDateTime> deadline = TestGuardUtils.extractDeadline(context.testClass(), context.testMethod());
        if (deadline.isPresent()) {
            return deadline.get();
        }
        throw new AnnotationFormatError(Messages.formatLocalized("test_guard.hidden_test_missing_deadline", context.displayName()));
    }

    public static Optional<LocalDateTime> extractDeadline(Optional<Class<?>> testClass, Optional<Method> testMethod) {
        Optional<LocalDateTime> methodLevel = TestGuardUtils.getDeadlineOf(testMethod);
        Optional<Duration> methodDelta = TestGuardUtils.getExtensionDurationOf(testMethod);
        if (methodLevel.isPresent()) {
            return methodLevel.map(dl -> dl.plus(methodDelta.orElse(Duration.ZERO)));
        }
        Optional<LocalDateTime> classLevel = AnnotationSupport.findAnnotation(testClass, Deadline.class).map(Deadline::value).map(TestGuardUtils::parseDeadline);
        Optional<Duration> classDelta = AnnotationSupport.findAnnotation(testClass, ExtendedDeadline.class).map(ExtendedDeadline::value).map(TestGuardUtils::parseDuration);
        return classLevel.map(dl -> dl.plus(classDelta.orElse(Duration.ZERO))).map(dl -> dl.plus(methodDelta.orElse(Duration.ZERO)));
    }

    public static Optional<LocalDateTime> extractActivationBefore(TestContext context) {
        Optional<LocalDateTime> methodLevel = TestGuardUtils.getActivationBeforeOf(context.testMethod());
        return methodLevel.or(() -> TestGuardUtils.getActivationBeforeOf(context.testClass()));
    }

    public static Optional<LocalDateTime> getDeadlineOf(Optional<? extends AnnotatedElement> element) {
        return AnnotationSupport.findAnnotation(element, Deadline.class).map(Deadline::value).map(TestGuardUtils::parseDeadline);
    }

    public static Optional<Duration> getExtensionDurationOf(Optional<? extends AnnotatedElement> element) {
        return AnnotationSupport.findAnnotation(element, ExtendedDeadline.class).map(ExtendedDeadline::value).map(TestGuardUtils::parseDuration);
    }

    public static Optional<LocalDateTime> getActivationBeforeOf(Optional<? extends AnnotatedElement> element) {
        return AnnotationSupport.findAnnotation(element, ActivateHiddenBefore.class).map(ActivateHiddenBefore::value).map(TestGuardUtils::parseDeadline);
    }

    @API(status=API.Status.INTERNAL)
    public static LocalDateTime parseDeadline(String deadlineString) {
        try {
            return LocalDateTime.parse(deadlineString.replace(' ', 'T'));
        }
        catch (DateTimeParseException e) {
            throw new AnnotationFormatError(Messages.formatLocalized("test_guard.invalid_deadline_format", deadlineString), e);
        }
    }

    @API(status=API.Status.INTERNAL)
    public static Duration parseDuration(String durationString) {
        Matcher matcher = DURATION_PATTERN.matcher(durationString);
        if (!matcher.matches()) {
            throw new AnnotationFormatError(Messages.formatLocalized("test_guard.invalid_extended_deadline_format", durationString));
        }
        Integer d = Optional.ofNullable(matcher.group("d")).map(Integer::parseInt).orElse(0);
        Integer h = Optional.ofNullable(matcher.group("h")).map(Integer::parseInt).orElse(0);
        Integer m = Optional.ofNullable(matcher.group("m")).map(Integer::parseInt).orElse(0);
        Duration duration = Duration.ofDays(d.intValue()).plusHours(h.intValue()).plusMinutes(m.intValue());
        if (duration.isZero() || duration.isNegative()) {
            throw new AnnotationFormatError(Messages.formatLocalized("test_guard.extended_deadline_zero_or_negative", durationString));
        }
        return duration;
    }
}

