/*
 * Decompiled with CFR 0.152.
 */
package de.tum.in.test.api.internal.sanitization;

import de.tum.in.test.api.internal.BlacklistedInvoker;
import de.tum.in.test.api.internal.sanitization.SanitizationError;
import de.tum.in.test.api.internal.sanitization.SpecificThrowableSanitizer;
import de.tum.in.test.api.internal.sanitization.ThrowableSanitizer;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.assertj.core.error.MultipleAssertionsError;

enum MultipleAssertionsErrorSanitizer implements SpecificThrowableSanitizer
{
    INSTANCE;

    private final Set<Class<? extends Throwable>> types = Set.of(MultipleAssertionsError.class);

    @Override
    public boolean canSanitize(Throwable t) {
        return this.types.contains(t.getClass());
    }

    @Override
    public Throwable sanitize(Throwable t) throws SanitizationError {
        MultipleAssertionsError mae = new MultipleAssertionsError(List.copyOf(BlacklistedInvoker.invoke(() -> ((MultipleAssertionsError)t).getErrors().stream().map(ThrowableSanitizer::sanitize).map(ae -> (AssertionError)((Object)ae)).collect(Collectors.toList()))));
        ThrowableSanitizer.copyThrowableInfo(t, (Throwable)mae);
        return mae;
    }
}

