/*
 * Decompiled with CFR 0.152.
 */
package de.tum.in.test.api.internal.sanitization;

import de.tum.in.test.api.internal.BlacklistedInvoker;
import de.tum.in.test.api.internal.sanitization.SanitizationError;
import de.tum.in.test.api.internal.sanitization.SpecificThrowableSanitizer;
import de.tum.in.test.api.internal.sanitization.ThrowableSanitizer;
import de.tum.in.test.api.internal.sanitization.ThrowableSets;
import de.tum.in.test.api.security.ArtemisSecurityManager;
import de.tum.in.test.api.util.IgnorantUnmodifiableList;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.stream.Collectors;

enum SimpleThrowableSanitizer implements SpecificThrowableSanitizer
{
    INSTANCE;


    @Override
    public boolean canSanitize(Throwable t) {
        return ThrowableSets.SAFE_TYPES.contains(t.getClass());
    }

    @Override
    public Throwable sanitize(Throwable t) throws SanitizationError {
        Throwable causeVal = BlacklistedInvoker.invoke(t::getCause);
        Throwable[] supprVal = BlacklistedInvoker.invoke(t::getSuppressed);
        try {
            Field cause = Throwable.class.getDeclaredField("cause");
            cause.setAccessible(true);
            cause.set(t, ThrowableSanitizer.sanitize(causeVal));
        }
        catch (ReflectiveOperationException e) {
            throw new SanitizationError(e);
        }
        try {
            Field suppr = Throwable.class.getDeclaredField("suppressedExceptions");
            suppr.setAccessible(true);
            suppr.set(t, IgnorantUnmodifiableList.wrapWith(Arrays.stream(supprVal).map(ThrowableSanitizer::sanitize).collect(Collectors.toList()), ArtemisSecurityManager.getOnSuppressedModification()));
        }
        catch (ReflectiveOperationException e) {
            throw new SanitizationError(e);
        }
        return t;
    }
}

