/*
 * Decompiled with CFR 0.152.
 */
package de.tum.in.test.api.internal.sanitization;

import de.tum.in.test.api.internal.BlacklistedInvoker;
import de.tum.in.test.api.internal.sanitization.AssertionFailedErrorSanitizer;
import de.tum.in.test.api.internal.sanitization.ExceptionInInitializerErrorSanitizer;
import de.tum.in.test.api.internal.sanitization.MultipleAssertionsErrorSanitizer;
import de.tum.in.test.api.internal.sanitization.MultipleFailuresErrorSanitizer;
import de.tum.in.test.api.internal.sanitization.PrivilegedExceptionSanitizer;
import de.tum.in.test.api.internal.sanitization.SanitizationError;
import de.tum.in.test.api.internal.sanitization.SimpleThrowableSanitizer;
import de.tum.in.test.api.internal.sanitization.SoftAssertionErrorSanitizer;
import de.tum.in.test.api.internal.sanitization.SpecificThrowableSanitizer;
import de.tum.in.test.api.internal.sanitization.ThrowableSets;
import de.tum.in.test.api.security.ArtemisSecurityManager;
import de.tum.in.test.api.util.IgnorantUnmodifiableList;
import de.tum.in.test.api.util.UnexpectedExceptionError;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apiguardian.api.API;

@API(status=API.Status.INTERNAL)
public final class ThrowableSanitizer {
    private static final List<SpecificThrowableSanitizer> SANITIZERS;
    private static final Field STACKTRACE;
    private static final Field CAUSE;
    private static final Field SUPPRESSED;

    private ThrowableSanitizer() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Throwable sanitize(Throwable t) throws SanitizationError {
        if (t == null) {
            return null;
        }
        Throwable throwable = t;
        synchronized (throwable) {
            if (UnexpectedExceptionError.class.equals(t.getClass())) {
                return t;
            }
            Optional<SpecificThrowableSanitizer> firstPossibleSan = SANITIZERS.stream().filter(s -> s.canSanitize(t)).findFirst();
            if (firstPossibleSan.isPresent()) {
                return firstPossibleSan.get().sanitize(t);
            }
            return UnexpectedExceptionError.wrap(t);
        }
    }

    static void copyThrowableInfo(Throwable from, Throwable to) throws SanitizationError {
        to.setStackTrace(from.getStackTrace());
        try {
            Throwable cause = (Throwable)CAUSE.get(from);
            List suppr = IgnorantUnmodifiableList.wrapWith(Arrays.stream(BlacklistedInvoker.invoke(from::getSuppressed)).map(ThrowableSanitizer::sanitize).collect(Collectors.toList()), ArtemisSecurityManager.getOnSuppressedModification());
            if (cause == from) {
                CAUSE.set(to, to);
            } else {
                CAUSE.set(to, ThrowableSanitizer.sanitize(cause));
            }
            SUPPRESSED.set(to, suppr);
        }
        catch (IllegalArgumentException | ReflectiveOperationException e) {
            throw new SanitizationError(e);
        }
    }

    static {
        ThrowableSets.SAFE_TYPES.size();
        SANITIZERS = List.of(SimpleThrowableSanitizer.INSTANCE, AssertionFailedErrorSanitizer.INSTANCE, PrivilegedExceptionSanitizer.INSTANCE, MultipleFailuresErrorSanitizer.INSTANCE, MultipleAssertionsErrorSanitizer.INSTANCE, ExceptionInInitializerErrorSanitizer.INSTANCE, SoftAssertionErrorSanitizer.INSTANCE);
        try {
            STACKTRACE = Throwable.class.getDeclaredField("stackTrace");
            STACKTRACE.setAccessible(true);
            CAUSE = Throwable.class.getDeclaredField("cause");
            CAUSE.setAccessible(true);
            SUPPRESSED = Throwable.class.getDeclaredField("suppressedExceptions");
            SUPPRESSED.setAccessible(true);
        }
        catch (NoSuchFieldException | SecurityException e) {
            throw new ExceptionInInitializerError(e);
        }
    }
}

