/*
 * Decompiled with CFR 0.152.
 */
package de.tum.in.test.api.security;

import de.tum.in.test.api.internal.TestContext;
import de.tum.in.test.api.security.ArtemisSecurityConfiguration;
import de.tum.in.test.api.security.ArtemisSecurityConfigurationImpl;
import de.tum.in.test.api.util.PackageRule;
import de.tum.in.test.api.util.PathRule;
import java.lang.reflect.Method;
import java.nio.file.Path;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.Set;

public final class ArtemisSecurityConfigurationBuilder {
    private Class<?> testClass;
    private Method testMethod;
    private Path executionPath;
    private Set<String> whitelistedClassNames = new HashSet<String>();
    private Set<PathRule> whitelistedPaths;
    private Set<PathRule> blacklistedPaths = Set.of();
    private Set<PackageRule> blacklistedPackages = Set.of();
    private Set<PackageRule> whitelistedPackages = Set.of();
    private OptionalInt allowedLocalPort = OptionalInt.empty();
    private OptionalInt allowedThreadCount = OptionalInt.empty();

    private ArtemisSecurityConfigurationBuilder() {
    }

    public Class<?> getTestClass() {
        return this.testClass;
    }

    public Method getTestMethod() {
        return this.testMethod;
    }

    public Path getExecutionPath() {
        return this.executionPath;
    }

    public Set<String> getWhitelistedClassNames() {
        return this.whitelistedClassNames;
    }

    public Set<PathRule> getWhitelistedPaths() {
        return this.whitelistedPaths;
    }

    public Set<PathRule> getBlacklistedPaths() {
        return this.blacklistedPaths;
    }

    public OptionalInt getAllowedLocalPort() {
        return this.allowedLocalPort;
    }

    public OptionalInt getAllowedThreadCount() {
        return this.allowedThreadCount;
    }

    public Set<PackageRule> getBlacklistedPackages() {
        return this.blacklistedPackages;
    }

    public Set<PackageRule> getWhitelistedPackages() {
        return this.whitelistedPackages;
    }

    public ArtemisSecurityConfigurationBuilder withCurrentPath() {
        this.executionPath = Path.of("", new String[0]);
        return this;
    }

    public ArtemisSecurityConfigurationBuilder withPath(Path executionPath) {
        this.executionPath = Objects.requireNonNull(executionPath);
        return this;
    }

    public ArtemisSecurityConfigurationBuilder withPathWhitelist(Collection<PathRule> whitelistedPaths) {
        this.whitelistedPaths = Set.copyOf(whitelistedPaths);
        return this;
    }

    public ArtemisSecurityConfigurationBuilder withPathWhitelist(Optional<? extends Collection<PathRule>> whitelistedPaths) {
        whitelistedPaths.ifPresentOrElse(this::withPathWhitelist, () -> {
            this.whitelistedPaths = null;
        });
        return this;
    }

    public ArtemisSecurityConfigurationBuilder withPathBlacklist(Collection<PathRule> blacklistedPaths) {
        this.blacklistedPaths = Set.copyOf(blacklistedPaths);
        return this;
    }

    public ArtemisSecurityConfigurationBuilder withTestClass(Class<?> testClass) {
        this.testClass = Objects.requireNonNull(testClass);
        return this;
    }

    public ArtemisSecurityConfigurationBuilder withTestMethod(Method testMethod) {
        this.testMethod = Objects.requireNonNull(testMethod);
        return this;
    }

    public ArtemisSecurityConfigurationBuilder withAllowedLocalPort(OptionalInt allowedLocalPort) {
        this.allowedLocalPort = Objects.requireNonNull(allowedLocalPort);
        return this;
    }

    public ArtemisSecurityConfigurationBuilder withAllowedThreadCount(OptionalInt allowedThreadCount) {
        this.allowedThreadCount = Objects.requireNonNull(allowedThreadCount);
        return this;
    }

    public ArtemisSecurityConfigurationBuilder allowLocalPort(int port) {
        this.allowedLocalPort = OptionalInt.of(port);
        return this;
    }

    public ArtemisSecurityConfigurationBuilder configureFromContext(TestContext context) {
        this.testClass = context.testClass().get();
        this.testMethod = context.testMethod().get();
        return this;
    }

    public ArtemisSecurityConfigurationBuilder addWhitelistedClassNames(String ... classNames) {
        return this.addWhitelistedClassNames(List.of(classNames));
    }

    public ArtemisSecurityConfigurationBuilder addWhitelistedClassNames(Collection<String> classNames) {
        this.whitelistedClassNames.addAll(classNames);
        return this;
    }

    public ArtemisSecurityConfigurationBuilder withPackageBlacklist(Collection<PackageRule> packageBlacklist) {
        this.blacklistedPackages = Set.copyOf(packageBlacklist);
        return this;
    }

    public ArtemisSecurityConfigurationBuilder withPackageWhitelist(Collection<PackageRule> packageWhitelist) {
        this.whitelistedPackages = Set.copyOf(packageWhitelist);
        return this;
    }

    public ArtemisSecurityConfiguration build() {
        return new ArtemisSecurityConfigurationImpl(this.testClass, this.testMethod, this.executionPath, this.whitelistedClassNames, Optional.ofNullable(this.whitelistedPaths), this.blacklistedPaths, this.allowedLocalPort, this.allowedThreadCount, this.blacklistedPackages, this.whitelistedPackages);
    }

    public static ArtemisSecurityConfigurationBuilder create() {
        return new ArtemisSecurityConfigurationBuilder();
    }
}

