/*
 * Decompiled with CFR 0.152.
 */
package de.tum.in.test.api.util;

import de.tum.in.test.api.BlacklistPath;
import de.tum.in.test.api.PathActionLevel;
import de.tum.in.test.api.PathType;
import de.tum.in.test.api.WhitelistPath;
import de.tum.in.test.api.util.RuleType;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.util.Objects;
import org.apiguardian.api.API;

@API(status=API.Status.INTERNAL)
public final class PathRule {
    private final RuleType ruleType;
    private final PathType pathType;
    private final PathActionLevel actionLevel;
    private final String pathPattern;
    private final PathMatcher pathMatcher;

    private PathRule(RuleType ruleType, PathType pathType, PathActionLevel actionLevel, String pathPattern) {
        this.ruleType = ruleType;
        this.pathType = pathType;
        this.actionLevel = actionLevel;
        this.pathPattern = pathPattern;
        this.pathMatcher = this.pathType.convertToPathMatcher(this.pathPattern);
    }

    public RuleType getRuleType() {
        return this.ruleType;
    }

    public PathType getPathType() {
        return this.pathType;
    }

    public PathActionLevel getActionLevel() {
        return this.actionLevel;
    }

    public String getPathPattern() {
        return this.pathPattern;
    }

    public PathMatcher getPathMatcher() {
        return this.pathMatcher;
    }

    public boolean matchesWithLevel(Path path, PathActionLevel request) {
        if (this.ruleType == RuleType.BLACKLIST) {
            return request.isAboveOrEqual(this.actionLevel) && this.pathMatcher.matches(path);
        }
        return request.isBelowOrEqual(this.actionLevel) && this.pathMatcher.matches(path);
    }

    public String toString() {
        return String.format("PathRule[\"%s\" (%s) in %s; level %s]", new Object[]{this.pathPattern, this.pathType, this.ruleType, this.actionLevel});
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.actionLevel, this.pathPattern, this.pathType, this.ruleType});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof PathRule)) {
            return false;
        }
        PathRule other = (PathRule)obj;
        return this.actionLevel == other.actionLevel && this.pathType == other.pathType && this.ruleType == other.ruleType && Objects.equals(this.pathPattern, other.pathPattern);
    }

    public static PathRule of(WhitelistPath whitelistedPath) {
        return new PathRule(RuleType.WHITELIST, whitelistedPath.type(), whitelistedPath.level(), whitelistedPath.value());
    }

    public static PathRule of(BlacklistPath blacklistedPath) {
        return new PathRule(RuleType.BLACKLIST, blacklistedPath.type(), blacklistedPath.level(), blacklistedPath.value());
    }
}

