/*
 * Decompiled with CFR 0.152.
 */
package de.tum.in.test.api;

import java.io.File;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.junit.platform.commons.util.LruCache;

public enum PathType {
    EXACT{

        @Override
        public PathMatcher convertToPathMatcher(String s) {
            return Path.of(s, new String[0]).toAbsolutePath().normalize()::equals;
        }
    }
    ,
    STARTS_WITH{

        @Override
        public PathMatcher convertToPathMatcher(String s) {
            Path begin = Path.of(s, new String[0]).toAbsolutePath().normalize();
            return p -> p.normalize().startsWith(begin);
        }
    }
    ,
    GLOB{

        @Override
        public PathMatcher convertToPathMatcher(String s) {
            GlobNormalizationResult normalizedGlob = GlobNormalizationResult.normalizeGlobPattern(s);
            PathMatcher pm = DEFAULT_FS.getPathMatcher("glob:" + normalizedGlob.getNormalizedGlobPattern());
            return p -> pm.matches(PathType.relativizeSafe(p, normalizedGlob.getRelativeOffset()));
        }
    }
    ,
    REGEX{

        @Override
        public PathMatcher convertToPathMatcher(String s) {
            PathMatcher pm = DEFAULT_FS.getPathMatcher("regex:" + s);
            return p -> pm.matches(PathType.relativizeSafe(p, 0));
        }
    }
    ,
    GLOB_ABSOLUTE{

        @Override
        public PathMatcher convertToPathMatcher(String s) {
            PathMatcher pm = DEFAULT_FS.getPathMatcher("glob:" + s);
            return p -> pm.matches(p.normalize());
        }
    }
    ,
    REGEX_ABSOLUTE{

        @Override
        public PathMatcher convertToPathMatcher(String s) {
            PathMatcher pm = DEFAULT_FS.getPathMatcher("regex:" + s);
            return p -> pm.matches(p.normalize());
        }
    };

    static final FileSystem DEFAULT_FS;
    static final Path CURRENT_PATH;
    static final List<Path> CURRENT_PATH_HIERARCHY;
    private static final int NO_OFFSET = 0;
    private static final Pattern GLOB_SINGLE_DOT_ELIMINATION;
    private static final Pattern GLOB_DOUBLE_DOT_ELIMINATION;

    public abstract PathMatcher convertToPathMatcher(String var1);

    private static Path relativizeSafe(Path any, int offset) {
        Path p = any.normalize().toAbsolutePath();
        if (!Objects.equals(p.getRoot(), CURRENT_PATH.getRoot())) {
            return p;
        }
        return CURRENT_PATH_HIERARCHY.get(offset).relativize(p).normalize();
    }

    static {
        DEFAULT_FS = FileSystems.getDefault();
        CURRENT_PATH = Path.of("", new String[0]).toAbsolutePath();
        CURRENT_PATH_HIERARCHY = Stream.iterate(CURRENT_PATH, Path::getParent).takeWhile(Objects::nonNull).collect(Collectors.toUnmodifiableList());
        String sepPat = "/".equals(File.separator) ? "/" : "[/\\\\]";
        String nonSepPat = "/".equals(File.separator) ? "(?!\\.\\./)[^/]+" : "(?!\\.\\.[/\\\\])(?:[^/\\\\])+";
        GLOB_SINGLE_DOT_ELIMINATION = Pattern.compile(String.format("^(?:\\.(?:%1$s|$))+|(?:%1$s\\.)(?=%1$s|$)|%1$s$", sepPat));
        GLOB_DOUBLE_DOT_ELIMINATION = Pattern.compile(String.format("^%2$s%1$s\\.\\.(?:%1$s|$)|%1$s%2$s%1$s\\.\\.(?=%1$s|$)", sepPat, nonSepPat));
    }

    static final class GlobNormalizationResult {
        private static final int CACHE_SIZE = 256;
        private static final Map<String, GlobNormalizationResult> CACHE = new LruCache(255);
        private final int relativeOffset;
        private final String normalizedGlobPattern;

        private GlobNormalizationResult(String globPattern) {
            Matcher m;
            String cleaned = GLOB_SINGLE_DOT_ELIMINATION.matcher(globPattern).replaceAll("");
            while ((m = GLOB_DOUBLE_DOT_ELIMINATION.matcher(cleaned)).find()) {
                cleaned = m.replaceAll("");
            }
            int offset = 0;
            while (cleaned.startsWith("..")) {
                cleaned = cleaned.length() == 2 ? "" : cleaned.substring(3);
                ++offset;
            }
            if (offset >= CURRENT_PATH_HIERARCHY.size()) {
                throw new IllegalArgumentException("relative glob pattern for current path requires offset " + offset);
            }
            this.relativeOffset = offset;
            this.normalizedGlobPattern = cleaned;
        }

        int getRelativeOffset() {
            return this.relativeOffset;
        }

        String getNormalizedGlobPattern() {
            return this.normalizedGlobPattern;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        static GlobNormalizationResult normalizeGlobPattern(String globPattern) {
            GlobNormalizationResult result;
            Map<String, GlobNormalizationResult> map = CACHE;
            synchronized (map) {
                result = CACHE.get(globPattern);
            }
            if (result == null) {
                result = new GlobNormalizationResult(globPattern);
                map = CACHE;
                synchronized (map) {
                    CACHE.put(globPattern, result);
                }
            }
            return result;
        }
    }
}

