/*
 * Decompiled with CFR 0.152.
 */
package de.tum.in.test.api.internal;

import de.tum.in.test.api.AllowLocalPort;
import de.tum.in.test.api.AllowThreads;
import de.tum.in.test.api.BlacklistPackage;
import de.tum.in.test.api.BlacklistPath;
import de.tum.in.test.api.MirrorOutput;
import de.tum.in.test.api.PrivilegedExceptionsOnly;
import de.tum.in.test.api.WhitelistClass;
import de.tum.in.test.api.WhitelistPackage;
import de.tum.in.test.api.WhitelistPath;
import de.tum.in.test.api.internal.TestContext;
import de.tum.in.test.api.internal.TestContextUtils;
import de.tum.in.test.api.security.ArtemisSecurityConfiguration;
import de.tum.in.test.api.security.ArtemisSecurityConfigurationBuilder;
import de.tum.in.test.api.util.PackageRule;
import de.tum.in.test.api.util.PathRule;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.Set;
import java.util.stream.Collectors;

public final class ConfigurationUtils {
    private ConfigurationUtils() {
    }

    public static ArtemisSecurityConfiguration generateConfiguration(TestContext context) {
        ArtemisSecurityConfigurationBuilder config = ArtemisSecurityConfigurationBuilder.create();
        config.configureFromContext(context);
        config.withCurrentPath();
        config.addWhitelistedClassNames(ConfigurationUtils.generateClassWhiteList(context));
        config.withPathWhitelist(ConfigurationUtils.generatePathWhiteList(context));
        config.withPathBlacklist(ConfigurationUtils.generatePathBlackList(context));
        config.withAllowedLocalPort(ConfigurationUtils.getAllowedLocalPort(context));
        config.withAllowedThreadCount(ConfigurationUtils.getAllowedThreadCount(context));
        config.withPackageBlacklist(ConfigurationUtils.generatePackageBlackList(context));
        config.withPackageWhitelist(ConfigurationUtils.generatePackageWhiteList(context));
        return config.build();
    }

    public static Set<PathRule> generatePathWhiteList(TestContext context) {
        return TestContextUtils.findRepeatableAnnotationsIn(context, WhitelistPath.class).flatMap(PathRule::allOf).collect(Collectors.toSet());
    }

    public static Set<PathRule> generatePathBlackList(TestContext context) {
        return TestContextUtils.findRepeatableAnnotationsIn(context, BlacklistPath.class).flatMap(PathRule::allOf).collect(Collectors.toSet());
    }

    public static Set<String> generateClassWhiteList(TestContext context) {
        Set entries = StackWalker.getInstance().walk(s -> s.map(StackWalker.StackFrame::getClassName).collect(Collectors.toCollection(HashSet::new)));
        TestContextUtils.getClassNestingInnermostFirst(context).map(Class::getName).forEach(entries::add);
        entries.addAll(ConfigurationUtils.getWhitelistedClasses(context));
        return entries;
    }

    public static Set<String> getWhitelistedClasses(TestContext context) {
        return TestContextUtils.findRepeatableAnnotationsIn(context, WhitelistClass.class).map(WhitelistClass::value).flatMap(Arrays::stream).map(Class::getName).collect(Collectors.toSet());
    }

    public static boolean shouldMirrorOutput(TestContext context) {
        return TestContextUtils.findAnnotationIn(context, MirrorOutput.class).map(MirrorOutput::value).map(MirrorOutput.MirrorOutputPolicy::isEnabled).orElse(false);
    }

    public static long getMaxStandardOutput(TestContext context) {
        return TestContextUtils.findAnnotationIn(context, MirrorOutput.class).map(MirrorOutput::maxCharCount).orElse(100000000L);
    }

    public static OptionalInt getAllowedLocalPort(TestContext context) {
        return TestContextUtils.findAnnotationIn(context, AllowLocalPort.class).map(AllowLocalPort::value).map(OptionalInt::of).orElseGet(OptionalInt::empty);
    }

    public static OptionalInt getAllowedThreadCount(TestContext context) {
        return TestContextUtils.findAnnotationIn(context, AllowThreads.class).map(AllowThreads::maxActiveCount).map(OptionalInt::of).orElseGet(OptionalInt::empty);
    }

    public static Set<PackageRule> generatePackageBlackList(TestContext context) {
        return TestContextUtils.findRepeatableAnnotationsIn(context, BlacklistPackage.class).flatMap(PackageRule::allOf).collect(Collectors.toSet());
    }

    public static Set<PackageRule> generatePackageWhiteList(TestContext context) {
        return TestContextUtils.findRepeatableAnnotationsIn(context, WhitelistPackage.class).flatMap(PackageRule::allOf).collect(Collectors.toSet());
    }

    public static Optional<String> getNonprivilegedFailureMessage(TestContext context) {
        return TestContextUtils.findAnnotationIn(context, PrivilegedExceptionsOnly.class).map(PrivilegedExceptionsOnly::value);
    }
}

