/*
 * Decompiled with CFR 0.152.
 */
package de.tum.in.test.api.internal;

import de.tum.in.test.api.internal.ConfigurationUtils;
import de.tum.in.test.api.internal.TestContext;
import de.tum.in.test.api.io.IOTester;
import de.tum.in.test.api.security.ArtemisSecurityManager;

public final class GeneralTestExtension {
    private final TestContext context;
    private String token;
    private IOTester ioTester;

    public GeneralTestExtension(TestContext context) {
        this.context = context;
    }

    public void beforeTestExecution() throws Exception {
        boolean mirrorOutput = ConfigurationUtils.shouldMirrorOutput(this.context);
        long maxStdOut = ConfigurationUtils.getMaxStandardOutput(this.context);
        this.ioTester = IOTester.installNew(mirrorOutput, maxStdOut);
        try {
            this.token = ArtemisSecurityManager.install(ConfigurationUtils.generateConfiguration(this.context));
        }
        catch (Throwable t) {
            try {
                IOTester.uninstallCurrent();
            }
            catch (Exception e) {
                t.addSuppressed(e);
            }
            throw t;
        }
    }

    public void afterTestExecution() throws Exception {
        try {
            ArtemisSecurityManager.uninstall(this.token);
        }
        finally {
            IOTester.uninstallCurrent();
            this.ioTester = null;
        }
    }

    public IOTester getIOTester() {
        return this.ioTester;
    }

    static {
        ArtemisSecurityManager.isInstalled();
    }
}

