/*
 * Decompiled with CFR 0.152.
 */
package de.tum.in.test.api.internal.sanitization;

import de.tum.in.test.api.internal.sanitization.AssertionFailedErrorSanitizer;
import de.tum.in.test.api.internal.sanitization.ExceptionInInitializerErrorSanitizer;
import de.tum.in.test.api.internal.sanitization.MultipleAssertionsErrorSanitizer;
import de.tum.in.test.api.internal.sanitization.MultipleFailuresErrorSanitizer;
import de.tum.in.test.api.internal.sanitization.PrivilegedExceptionSanitizer;
import de.tum.in.test.api.internal.sanitization.SanitizationUtils;
import de.tum.in.test.api.internal.sanitization.SimpleThrowableSanitizer;
import de.tum.in.test.api.internal.sanitization.SoftAssertionErrorSanitizer;
import de.tum.in.test.api.internal.sanitization.SpecificThrowableSanitizer;
import de.tum.in.test.api.internal.sanitization.ThrowableSets;
import de.tum.in.test.api.util.UnexpectedExceptionError;
import java.util.List;
import java.util.Optional;
import org.apiguardian.api.API;

@API(status=API.Status.INTERNAL)
public final class ThrowableSanitizer {
    private static final List<SpecificThrowableSanitizer> SANITIZERS;

    private ThrowableSanitizer() {
    }

    public static Throwable sanitize(Throwable t) {
        if (t == null) {
            return null;
        }
        return SanitizationUtils.sanitizeWithinScopeOf(t, () -> {
            if (UnexpectedExceptionError.class.equals(t.getClass())) {
                return t;
            }
            Optional<SpecificThrowableSanitizer> firstPossibleSan = SANITIZERS.stream().filter(s -> s.canSanitize(t)).findFirst();
            if (firstPossibleSan.isPresent()) {
                return firstPossibleSan.get().sanitize(t);
            }
            return UnexpectedExceptionError.wrap(t);
        });
    }

    static {
        ThrowableSets.SAFE_TYPES.size();
        SANITIZERS = List.of(SimpleThrowableSanitizer.INSTANCE, AssertionFailedErrorSanitizer.INSTANCE, PrivilegedExceptionSanitizer.INSTANCE, MultipleFailuresErrorSanitizer.INSTANCE, MultipleAssertionsErrorSanitizer.INSTANCE, ExceptionInInitializerErrorSanitizer.INSTANCE, SoftAssertionErrorSanitizer.INSTANCE);
    }
}

