/*
 * Decompiled with CFR 0.152.
 */
package de.tum.in.test.api.jqwik;

import de.tum.in.test.api.internal.GeneralTestExtension;
import de.tum.in.test.api.io.IOTester;
import de.tum.in.test.api.jqwik.JqwikContext;
import java.util.Optional;
import java.util.Set;
import net.jqwik.api.Arbitraries;
import net.jqwik.api.Arbitrary;
import net.jqwik.api.lifecycle.AroundPropertyHook;
import net.jqwik.api.lifecycle.PropertyExecutionResult;
import net.jqwik.api.lifecycle.PropertyExecutor;
import net.jqwik.api.lifecycle.PropertyLifecycleContext;
import net.jqwik.api.providers.ArbitraryProvider;
import net.jqwik.api.providers.TypeUsage;
import net.jqwik.engine.providers.RegisteredArbitraryProviders;
import org.apiguardian.api.API;

@API(status=API.Status.INTERNAL)
public final class JqwikTestExtension
implements AroundPropertyHook {
    public int aroundPropertyProximity() {
        return 20;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PropertyExecutionResult aroundProperty(PropertyLifecycleContext context, PropertyExecutor property) throws Throwable {
        PropertyExecutionResult result;
        GeneralTestExtension testExtension = new GeneralTestExtension(JqwikContext.of(context));
        testExtension.beforeTestExecution();
        IOTesterProvider ioTesterProvider = new IOTesterProvider(testExtension.getIOTester());
        RegisteredArbitraryProviders.register((ArbitraryProvider)ioTesterProvider);
        Throwable error = null;
        try {
            result = property.execute();
        }
        finally {
            RegisteredArbitraryProviders.unregister((ArbitraryProvider)ioTesterProvider);
            try {
                testExtension.afterTestExecution();
            }
            catch (Throwable t) {
                error = t;
            }
        }
        if (error != null) {
            Optional propExecError = result.throwable();
            if (propExecError.isPresent()) {
                ((Throwable)propExecError.get()).addSuppressed(error);
            } else {
                result = result.mapToFailed(error);
            }
        }
        return result;
    }

    private static class IOTesterProvider
    implements ArbitraryProvider {
        private final IOTester ioTester;

        public IOTesterProvider(IOTester ioTester) {
            this.ioTester = ioTester;
        }

        public boolean canProvideFor(TypeUsage targetType) {
            return targetType.getRawType().equals(IOTester.class);
        }

        public Set<Arbitrary<?>> provideFor(TypeUsage targetType, ArbitraryProvider.SubtypeProvider subtypeProvider) {
            return Set.of(Arbitraries.just((Object)this.ioTester));
        }
    }
}

