/*
 * Decompiled with CFR 0.152.
 */
package de.tum.in.test.api.jupiter;

import de.tum.in.test.api.internal.ReportingUtils;
import de.tum.in.test.api.internal.TestGuardUtils;
import de.tum.in.test.api.internal.TestType;
import de.tum.in.test.api.jupiter.JupiterArtemisTest;
import de.tum.in.test.api.jupiter.JupiterContext;
import de.tum.in.test.api.localization.Messages;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.time.ZonedDateTime;
import java.util.Optional;
import org.apiguardian.api.API;
import org.junit.jupiter.api.DisplayNameGenerator;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.InvocationInterceptor;
import org.junit.jupiter.api.extension.ReflectiveInvocationContext;
import org.junit.platform.commons.support.AnnotationSupport;

@API(status=API.Status.INTERNAL)
public final class JupiterTestGuard
implements InvocationInterceptor,
DisplayNameGenerator {
    private final DisplayNameGenerator defaultNameGen = new DisplayNameGenerator.ReplaceUnderscores();

    public void interceptDynamicTest(InvocationInterceptor.Invocation<Void> invocation, ExtensionContext extensionContext) throws Throwable {
        JupiterTestGuard.proceedWithInvocation(invocation, extensionContext);
    }

    public <T> T interceptTestFactoryMethod(InvocationInterceptor.Invocation<T> invocation, ReflectiveInvocationContext<Method> invocationContext, ExtensionContext extensionContext) throws Throwable {
        return JupiterTestGuard.proceedWithInvocation(invocation, extensionContext);
    }

    public void interceptTestMethod(InvocationInterceptor.Invocation<Void> invocation, ReflectiveInvocationContext<Method> invocationContext, ExtensionContext extensionContext) throws Throwable {
        JupiterTestGuard.proceedWithInvocation(invocation, extensionContext);
    }

    public void interceptTestTemplateMethod(InvocationInterceptor.Invocation<Void> invocation, ReflectiveInvocationContext<Method> invocationContext, ExtensionContext extensionContext) throws Throwable {
        JupiterTestGuard.proceedWithInvocation(invocation, extensionContext);
    }

    public <T> T interceptTestClassConstructor(InvocationInterceptor.Invocation<T> invocation, ReflectiveInvocationContext<Constructor<T>> invocationContext, ExtensionContext extensionContext) throws Throwable {
        return JupiterTestGuard.proceedWithInvocation(invocation, extensionContext);
    }

    public void interceptBeforeEachMethod(InvocationInterceptor.Invocation<Void> invocation, ReflectiveInvocationContext<Method> invocationContext, ExtensionContext extensionContext) throws Throwable {
        JupiterTestGuard.proceedWithInvocation(invocation, extensionContext);
    }

    public void interceptBeforeAllMethod(InvocationInterceptor.Invocation<Void> invocation, ReflectiveInvocationContext<Method> invocationContext, ExtensionContext extensionContext) throws Throwable {
        JupiterTestGuard.proceedWithInvocation(invocation, extensionContext);
    }

    public void interceptAfterEachMethod(InvocationInterceptor.Invocation<Void> invocation, ReflectiveInvocationContext<Method> invocationContext, ExtensionContext extensionContext) throws Throwable {
        JupiterTestGuard.proceedWithInvocation(invocation, extensionContext);
    }

    public void interceptAfterAllMethod(InvocationInterceptor.Invocation<Void> invocation, ReflectiveInvocationContext<Method> invocationContext, ExtensionContext extensionContext) throws Throwable {
        JupiterTestGuard.proceedWithInvocation(invocation, extensionContext);
    }

    private static <T> T proceedWithInvocation(InvocationInterceptor.Invocation<T> invocation, ExtensionContext extensionContext) throws Throwable {
        JupiterContext jupiterContext = JupiterContext.of(extensionContext);
        TestGuardUtils.checkForHidden(jupiterContext);
        return ReportingUtils.doProceedAndPostProcess(invocation, jupiterContext);
    }

    public String generateDisplayNameForClass(Class<?> testClass) {
        return this.defaultNameGen.generateDisplayNameForClass(testClass);
    }

    public String generateDisplayNameForNestedClass(Class<?> nestedClass) {
        return this.defaultNameGen.generateDisplayNameForNestedClass(nestedClass);
    }

    public String generateDisplayNameForMethod(Class<?> testClass, Method testMethod) {
        if (AnnotationSupport.findAnnotation((AnnotatedElement)testMethod, JupiterArtemisTest.class).map(JupiterArtemisTest::value).orElse(null) == TestType.HIDDEN) {
            Optional<ZonedDateTime> deadline = TestGuardUtils.extractDeadline(Optional.of(testClass), Optional.of(testMethod));
            String name = testMethod.toString();
            if (deadline.isEmpty()) {
                return Messages.formatLocalized("test_guard.obfuscate_hidden_test_missing_deadline", name);
            }
            if (ZonedDateTime.now().isBefore(deadline.get())) {
                return String.format("Hidden Test %08X", name.hashCode());
            }
        }
        return this.defaultNameGen.generateDisplayNameForMethod(testClass, testMethod);
    }
}

