/*
 * Decompiled with CFR 0.152.
 */
package de.tum.in.test.api.security;

import de.tum.in.test.api.PathActionLevel;
import de.tum.in.test.api.localization.Messages;
import de.tum.in.test.api.security.ArtemisSecurityConfiguration;
import de.tum.in.test.api.security.SecurityConstants;
import de.tum.in.test.api.util.DelayedFilter;
import de.tum.in.test.api.util.PackageRule;
import de.tum.in.test.api.util.PathRule;
import java.awt.AWTPermission;
import java.io.FilePermission;
import java.io.SerializablePermission;
import java.lang.invoke.LambdaMetafactory;
import java.lang.management.ManagementPermission;
import java.lang.reflect.ReflectPermission;
import java.net.InetAddress;
import java.net.NetPermission;
import java.net.SocketPermission;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.Permission;
import java.security.SecurityPermission;
import java.util.Arrays;
import java.util.Base64;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.net.ssl.SSLPermission;
import javax.security.auth.AuthPermission;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ArtemisSecurityManager
extends SecurityManager {
    private static final SecurityManager ORIGINAL = System.getSecurityManager();
    private static final ArtemisSecurityManager INSTANCE = new ArtemisSecurityManager();
    private static final Logger LOG = LoggerFactory.getLogger(ArtemisSecurityManager.class);
    private static final MessageDigest SHA256;
    private static final BiConsumer<String, Object> ON_SUPPRESSED_MOD;
    private final ThreadGroup testThreadGroup = new ThreadGroup("Test-Threadgroup");
    private final ThreadLocal<AtomicInteger> recursionBreak = ThreadLocal.withInitial(AtomicInteger::new);
    private final StackWalker stackWalker = StackWalker.getInstance();
    private ArtemisSecurityConfiguration configuration;
    private String accessToken;
    private Set<Thread> whitelistedThreads = new HashSet<Thread>();
    private volatile boolean isPartlyDisabled;
    private volatile boolean blockThreadCreation;
    private volatile boolean lastUninstallFailed;
    private volatile boolean isActive;

    private ArtemisSecurityManager() {
        if (INSTANCE != null) {
            throw new IllegalStateException(Messages.localized("security.already_created"));
        }
    }

    private synchronized String generateAccessToken() {
        String tokenString = UUID.randomUUID().toString();
        this.accessToken = ArtemisSecurityManager.hash(tokenString);
        return tokenString;
    }

    private synchronized void checkAccess(String accessToken) {
        if (!this.accessToken.equals(ArtemisSecurityManager.hash(accessToken))) {
            throw new SecurityException(Messages.localized("security.access_token_invalid"));
        }
    }

    private boolean enterPublicInterface() {
        return this.recursionBreak.get().getAndIncrement() > 0;
    }

    private boolean exitPublicInterface() {
        return this.recursionBreak.get().getAndDecrement() > 0;
    }

    private <T> T externGet(Supplier<T> supplier) {
        try {
            this.exitPublicInterface();
            T t = supplier.get();
            return t;
        }
        finally {
            this.enterPublicInterface();
        }
    }

    @Override
    public void checkExit(int status) {
        try {
            if (this.enterPublicInterface()) {
                return;
            }
            if (Thread.currentThread() == SecurityConstants.MAIN_THREAD && this.getNonWhitelistedStackFrames().isEmpty()) {
                return;
            }
            throw new SecurityException(Messages.localized("security.error_system_exit"));
        }
        finally {
            this.exitPublicInterface();
        }
    }

    @Override
    public void checkAccept(String host, int port) {
        try {
            if (this.enterPublicInterface()) {
                return;
            }
            if (this.isConnectionAllowed(host, port)) {
                return;
            }
            throw new SecurityException(Messages.formatLocalized("security.error_network_accept", host, port));
        }
        finally {
            this.exitPublicInterface();
        }
    }

    @Override
    public void checkConnect(String host, int port) {
        try {
            if (this.enterPublicInterface()) {
                return;
            }
            if (this.isConnectionAllowed(host, port)) {
                return;
            }
            throw new SecurityException(Messages.formatLocalized("security.error_network_connect", host, port));
        }
        finally {
            this.exitPublicInterface();
        }
    }

    @Override
    public void checkConnect(String host, int port, Object context) {
        try {
            if (this.enterPublicInterface()) {
                return;
            }
            if (this.isConnectionAllowed(host, port)) {
                return;
            }
            throw new SecurityException(Messages.formatLocalized("security.error_network_connect_with_context", host, port));
        }
        finally {
            this.exitPublicInterface();
        }
    }

    @Override
    public void checkListen(int port) {
        try {
            if (this.enterPublicInterface()) {
                return;
            }
            if (this.isConnectionAllowed("localhost", port)) {
                return;
            }
            throw new SecurityException(Messages.formatLocalized("security.error_network_listen", port));
        }
        finally {
            this.exitPublicInterface();
        }
    }

    @Override
    public void checkMulticast(InetAddress maddr) {
        try {
            if (this.enterPublicInterface()) {
                return;
            }
            throw new SecurityException(Messages.localized("security.error_network_multicast"));
        }
        finally {
            this.exitPublicInterface();
        }
    }

    @Override
    public void checkExec(String cmd) {
        try {
            if (this.enterPublicInterface()) {
                return;
            }
            throw new SecurityException(Messages.localized("security.error_execute"));
        }
        finally {
            this.exitPublicInterface();
        }
    }

    @Override
    public void checkPrintJobAccess() {
        try {
            if (this.enterPublicInterface()) {
                return;
            }
            throw new SecurityException(Messages.localized("security.error_printer"));
        }
        finally {
            this.exitPublicInterface();
        }
    }

    @Override
    public void checkCreateClassLoader() {
        try {
            if (this.enterPublicInterface()) {
                return;
            }
            if (this.isMainThreadAndInactive()) {
                LOG.trace("Allowing main thread to create a ClassLoader inbetween tests");
                return;
            }
            this.checkForNonWhitelistedStackFrames(() -> Messages.localized("security.error_classloader"));
        }
        finally {
            this.exitPublicInterface();
        }
    }

    @Override
    public void checkAccess(Thread t) {
        ThreadGroup tg = t.getThreadGroup();
        try {
            if (this.enterPublicInterface()) {
                return;
            }
            super.checkAccess(t);
            if (tg == null) {
                return;
            }
            if (this.isMainThreadAndInactive()) {
                LOG.trace("Allowing Thread access to {} for main thread inbetween tests", (Object)this.externGet(t::toString));
                return;
            }
            if (!this.testThreadGroup.parentOf(tg)) {
                this.checkForNonWhitelistedStackFrames(() -> Messages.localized("security.error_thread_access"));
            }
        }
        finally {
            this.exitPublicInterface();
        }
    }

    @Override
    public void checkAccess(ThreadGroup g) {
        try {
            if (this.enterPublicInterface()) {
                return;
            }
            super.checkAccess(g);
            if (this.isMainThreadAndInactive()) {
                LOG.trace("Allowing ThreadGroup access to {} for main thread inbetween tests", (Object)this.externGet(g::toString));
                return;
            }
            if (!this.testThreadGroup.parentOf(g)) {
                this.checkForNonWhitelistedStackFrames(() -> Messages.localized("security.error_threadgroup_access"));
            }
            this.checkThreadCreation();
        }
        finally {
            this.exitPublicInterface();
        }
    }

    @Override
    public void checkPackageDefinition(String pkg) {
        try {
            if (this.enterPublicInterface()) {
                return;
            }
            LOG.info("PKG-DEF: {}", (Object)pkg);
            super.checkPackageDefinition(pkg);
            if (SecurityConstants.STACK_WHITELIST.stream().anyMatch(pkg::startsWith)) {
                throw new SecurityException(Messages.formatLocalized("security.error_package_definition", pkg));
            }
        }
        finally {
            this.exitPublicInterface();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void checkPermission(Permission perm) {
        String permName = perm.getName();
        String permActions = perm.getActions();
        String permString = String.valueOf(perm);
        try {
            if (this.enterPublicInterface()) {
                return;
            }
            List<String> whitelist = List.of("getClassLoader", "accessSystemModules");
            if (whitelist.contains(permName)) {
                return;
            }
            List<String> blacklist = List.of("manageProcess", "shutdownHooks", "createSecurityManager");
            if (blacklist.contains(permName)) {
                throw new SecurityException(Messages.localized("security.error_blacklist") + permString);
            }
            if ("setIO".equals(permName) && !this.isMainThreadAndInactive()) {
                this.checkForNonWhitelistedStackFrames(() -> Messages.localized("security.error_blacklist") + permString);
            }
            if ("setSecurityManager".equals(permName) && !this.isPartlyDisabled) {
                throw new SecurityException(Messages.localized("security.error_security_manager"));
            }
            if (perm instanceof SerializablePermission) {
                throw new SecurityException(Messages.localized("security.error_modify_serialization") + permString);
            }
            if (perm instanceof AWTPermission) {
                throw new SecurityException(Messages.localized("security.error_awt") + permString);
            }
            if (perm instanceof ManagementPermission) {
                this.checkForNonWhitelistedStackFrames(() -> Messages.localized("security.error_management") + permString);
            }
            if ((this.configuration == null || this.configuration.allowedLocalPort().isEmpty()) && (perm instanceof NetPermission || perm instanceof SocketPermission)) {
                throw new SecurityException(Messages.localized("security.error_networking") + permString);
            }
            if (perm instanceof SecurityPermission) {
                if (permName.startsWith("getPolicy") || permName.startsWith("getProperty")) {
                    return;
                }
                this.checkForNonWhitelistedStackFrames(() -> Messages.localized("security.error_modify_security") + permString);
            }
            if (perm instanceof SSLPermission) {
                throw new SecurityException(Messages.localized("security.error_modify_ssl") + permString);
            }
            if (perm instanceof AuthPermission) {
                throw new SecurityException(Messages.localized("security.error_modify_auth") + permString);
            }
            if (perm instanceof FilePermission) {
                this.checkPathAccess(Path.of(permName, new String[0]), PathActionLevel.getLevelOf(permActions));
            }
            if (perm instanceof ReflectPermission || "accessDeclaredMembers".equals(permName)) {
                this.checkForNonWhitelistedStackFrames(() -> Messages.localized("security.error_modify_security") + permString);
            }
        }
        finally {
            this.exitPublicInterface();
        }
    }

    private void checkPathAccess(Path p, PathActionLevel pathActionLevel) {
        boolean whitelisted = false;
        boolean blacklisted = false;
        try {
            Path pa = p.toAbsolutePath();
            blacklisted = this.isPathBlacklisted(pa, pathActionLevel);
            whitelisted = this.isPathWhitelisted(pa, pathActionLevel);
            if (!blacklisted && whitelisted) {
                return;
            }
        }
        catch (Exception e) {
            LOG.warn("Error in checkPathAccess", (Throwable)e);
        }
        if (this.isMainThreadAndInactive() && pathActionLevel.isBelowOrEqual(PathActionLevel.READLINK)) {
            LOG.trace("Allowing read access for main thread inbetween tests");
            return;
        }
        String message = String.format("BAD PATH ACCESS: %s (BL:%s, WL:%s)", p, blacklisted, whitelisted);
        this.checkForNonWhitelistedStackFrames(() -> {
            LOG.warn(message);
            return Messages.formatLocalized("security.error_path_access", p);
        });
    }

    private boolean isPathWhitelisted(Path pa, PathActionLevel pathActionLevel) {
        Optional<Set<PathRule>> pathWhitelist = this.configuration.whitelistedPaths();
        if (pathWhitelist.isEmpty()) {
            return pa.startsWith(this.configuration.executionPath());
        }
        return pathWhitelist.get().stream().anyMatch(pm -> pm.matchesWithLevel(pa, pathActionLevel));
    }

    private boolean isPathBlacklisted(Path pa, PathActionLevel pathActionLevel) {
        Set<PathRule> pathBlacklist = this.configuration.blacklistedPaths();
        return pathBlacklist.stream().anyMatch(pm -> pm.matchesWithLevel(pa, pathActionLevel));
    }

    @Override
    public void checkPackageAccess(String pkg) {
        try {
            if (this.enterPublicInterface()) {
                return;
            }
            super.checkPackageAccess(pkg);
            if (!this.isMainThreadAndInactive() && this.isPackageAccessForbidden(pkg)) {
                this.checkForNonWhitelistedStackFrames(() -> {
                    LOG.warn("BAD PACKAGE ACCESS: {} (BL:{}, WL:{})", new Object[]{pkg, this.isPackageBlacklisted(pkg), this.isPackageWhitelisted(pkg)});
                    return Messages.formatLocalized("security.error_disallowed_package", pkg);
                });
            }
        }
        finally {
            this.exitPublicInterface();
        }
    }

    private boolean isPackageAccessForbidden(String pkg) {
        return SecurityConstants.PACKAGE_USE_BLACKLIST.stream().anyMatch(pkg::startsWith) || this.isPackageBlacklisted(pkg) && !this.isPackageWhitelisted(pkg);
    }

    private boolean isPackageBlacklisted(String packageName) {
        Set<PackageRule> packageBlacklist = this.configuration.blacklistedPackages();
        return packageBlacklist.stream().anyMatch(pm -> pm.matches(packageName));
    }

    private boolean isPackageWhitelisted(String packageName) {
        Set<PackageRule> packageWhitelist = this.configuration.whitelistedPackages();
        return packageWhitelist.stream().anyMatch(pm -> pm.matches(packageName));
    }

    private void checkForNonWhitelistedStackFrames(Supplier<String> message) {
        List<StackWalker.StackFrame> nonWhitelisted = this.getNonWhitelistedStackFrames();
        if (!nonWhitelisted.isEmpty()) {
            LOG.warn("NWSFs ==> {}", nonWhitelisted);
            StackWalker.StackFrame first = nonWhitelisted.get(0);
            throw new SecurityException(Messages.formatLocalized("security.stackframe_add_info", message.get(), first.getLineNumber(), first.getFileName()));
        }
    }

    private List<StackWalker.StackFrame> getNonWhitelistedStackFrames() {
        DelayedFilter<StackWalker.StackFrame> delayedIsNotPrivileged = new DelayedFilter<StackWalker.StackFrame>(2, this::isNotPrivileged, true);
        List result = this.isCurrentThreadWhitelisted() ? this.stackWalker.walk(sfs -> sfs.takeWhile(delayedIsNotPrivileged).filter(this::isStackFrameNotWhitelisted).collect(Collectors.toList())) : this.stackWalker.walk(sfs -> sfs.takeWhile(delayedIsNotPrivileged).collect(Collectors.toList()));
        return result;
    }

    private boolean isNotPrivileged(StackWalker.StackFrame stackFrame) {
        return !LambdaMetafactory.class.getName().equals(stackFrame.getClassName());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean isCallNotWhitelisted(String call) {
        if (SecurityConstants.STACK_BLACKLIST.stream().anyMatch(call::startsWith)) return true;
        if (!SecurityConstants.STACK_WHITELIST.stream().noneMatch(call::startsWith)) return false;
        if (this.configuration == null) return true;
        if (this.configuration.whitelistedClassNames().contains(call)) return false;
        return true;
    }

    private boolean isStackFrameNotWhitelisted(StackWalker.StackFrame sf) {
        return this.isCallNotWhitelisted(sf.getClassName());
    }

    private boolean isStackFrameNotWhitelisted(StackTraceElement ste) {
        return this.isCallNotWhitelisted(ste.getClassName());
    }

    public static Optional<StackTraceElement> firstNonWhitelisted(StackTraceElement ... elements) {
        for (StackTraceElement ste : elements) {
            if (!INSTANCE.isStackFrameNotWhitelisted(ste)) continue;
            return Optional.ofNullable(ste);
        }
        return Optional.empty();
    }

    public static void checkCurrentStack(Supplier<String> exceptionMessage) {
        INSTANCE.checkForNonWhitelistedStackFrames(exceptionMessage);
    }

    private static boolean isLocalHost(String host) {
        return Objects.equals(host, "localhost") || Objects.equals(host, "127.0.0.1");
    }

    private boolean isConnectionAllowed(String host, int port) {
        List<StackWalker.StackFrame> nwsfs = this.getNonWhitelistedStackFrames();
        LOG.info("Connection use request: {}:{} [NWSFs: {}]", new Object[]{host, port, nwsfs.size()});
        if (nwsfs.isEmpty()) {
            return true;
        }
        return this.configuration != null && ArtemisSecurityManager.isLocalHost(host) && (this.configuration.allowedLocalPort().equals(OptionalInt.of(port)) || port == -1);
    }

    @Override
    public ThreadGroup getThreadGroup() {
        if (!this.isActive) {
            return super.getThreadGroup();
        }
        return this.testThreadGroup;
    }

    private Thread[] checkThreadGroup() {
        this.blockThreadCreation = true;
        int originalCount = this.testThreadGroup.activeCount();
        if (originalCount == 0) {
            return new Thread[0];
        }
        Object[] threads = new Thread[originalCount];
        this.testThreadGroup.enumerate((Thread[])threads);
        for (Thread thread : threads) {
            if (thread == null) continue;
            try {
                thread.interrupt();
                thread.join((long)(500 / originalCount) + 1L);
                LOG.debug("State {} after interrupt and join of {}", (Object)thread.getState(), (Object)thread);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
        if (this.testThreadGroup.activeCount() == 0) {
            return new Thread[0];
        }
        SecurityException exception = new SecurityException(Messages.formatLocalized("security.error_threads_not_stoppable", Arrays.toString(threads)));
        int alive = threads.length;
        block7: for (int i = 0; i < 50 && alive > 0; ++i) {
            alive = 0;
            for (Object thread : threads) {
                if (thread == null || !((Thread)thread).isAlive()) continue;
                ++alive;
                LOG.debug("Try {} to stop {}, state: {}", new Object[]{i + 1, thread, ((Thread)thread).getState()});
                ((Thread)thread).stop();
                try {
                    ((Thread)thread).join((long)(20 / originalCount) + 1L);
                }
                catch (InterruptedException e) {
                    LOG.warn("Error in checkThreadGroup 1", (Throwable)e);
                    exception.addSuppressed(e);
                    Thread.currentThread().interrupt();
                    break block7;
                }
            }
        }
        for (Object thread : threads) {
            if (thread == null || !((Thread)thread).isAlive()) continue;
            try {
                ((Thread)thread).join((long)(100 / originalCount) + 1L);
            }
            catch (InterruptedException e) {
                LOG.warn("Error in checkThreadGroup 2", (Throwable)e);
                exception.addSuppressed(e);
                Thread.currentThread().interrupt();
                break;
            }
            if (((Thread)thread).getState() == Thread.State.TERMINATED) continue;
            LOG.error("THREAD STOP ERROR: Thread {} is still in state {}", thread, (Object)((Thread)thread).getState());
        }
        if (this.testThreadGroup.activeCount() > 0) {
            throw exception;
        }
        return threads;
    }

    private void checkCommonThreadPool() {
        ForkJoinPool common = ForkJoinPool.commonPool();
        if (common.isQuiescent()) {
            return;
        }
        LOG.debug("Common pool is active: {} with number {} workers", (Object)(!common.isQuiescent() ? 1 : 0), (Object)common.getActiveThreadCount());
        ThreadGroup root = this.getRootThreadGroup();
        ThreadGroup[] tgs = new ThreadGroup[root.activeGroupCount() + 5];
        root.enumerate(tgs, true);
        ThreadGroup commong = Stream.of(tgs).filter(tg -> "InnocuousForkJoinWorkerThreadGroup".equals(tg.getName())).findFirst().orElseThrow(IllegalStateException::new);
        Thread[] threads = new Thread[commong.activeCount() + 5];
        commong.enumerate(threads);
        LOG.info("Try interrupt common pool");
        for (Thread thread : threads) {
            if (thread == null || !thread.isAlive()) continue;
            thread.interrupt();
        }
        try {
            Thread.sleep(100L);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        if (common.isQuiescent()) {
            return;
        }
        LOG.warn("There are still {} common pool workers active", (Object)common.getActiveThreadCount());
    }

    private void checkThreadCreation() {
        if (this.blockThreadCreation || this.configuration == null || this.configuration.allowedThreadCount().isEmpty()) {
            this.checkForNonWhitelistedStackFrames(() -> Messages.localized("security.error_thread_access"));
            return;
        }
        int current = this.testThreadGroup.activeCount();
        int max = this.configuration.allowedThreadCount().getAsInt();
        if (max < current) {
            this.checkForNonWhitelistedStackFrames(() -> Messages.formatLocalized("security.error_thread_maxExceeded", current, max));
        }
    }

    private ThreadGroup getRootThreadGroup() {
        ThreadGroup p;
        ThreadGroup group = this.testThreadGroup;
        while ((p = group.getParent()) != null) {
            group = p;
        }
        return group;
    }

    private boolean isMainThreadAndInactive() {
        return !this.isActive && Thread.currentThread() == SecurityConstants.MAIN_THREAD;
    }

    private boolean isCurrentThreadWhitelisted() {
        Thread current = Thread.currentThread();
        String name = this.externGet(current::getName);
        Set<String> blacklist = Set.of("Finalizer", "InnocuousThread", "ForkJoinPool.commonPool");
        if (blacklist.stream().anyMatch(name::startsWith)) {
            return false;
        }
        if (!this.testThreadGroup.parentOf(current.getThreadGroup())) {
            return true;
        }
        return this.whitelistedThreads.stream().anyMatch(t -> t.equals(current));
    }

    private void whitelistThread(Thread t) {
        LOG.info("Request whitelisting: {} {}", (Object)t, ArtemisSecurityManager.INSTANCE.whitelistedThreads);
        boolean whitelisted = this.isCurrentThreadWhitelisted();
        if (!whitelisted) {
            throw new SecurityException(Messages.localized("security.error_thread_whitelisting_failed"));
        }
        this.whitelistedThreads.add(t);
        LOG.info("Thread whitelisted: {}", (Object)t);
    }

    private void unwhitelistThreads() {
        this.whitelistedThreads.clear();
    }

    static boolean isStaticWhitelisted(String name) {
        return SecurityConstants.STACK_WHITELIST.stream().anyMatch(name::startsWith);
    }

    public static synchronized boolean isInstalled() {
        return System.getSecurityManager() instanceof ArtemisSecurityManager;
    }

    public static synchronized String install(ArtemisSecurityConfiguration configuration) {
        if (ArtemisSecurityManager.INSTANCE.lastUninstallFailed) {
            LOG.info("Try recovery from lastUninstallFailed");
            INSTANCE.checkThreadGroup();
            ArtemisSecurityManager.INSTANCE.isPartlyDisabled = true;
            System.setSecurityManager(ORIGINAL);
            ArtemisSecurityManager.INSTANCE.isPartlyDisabled = false;
            ArtemisSecurityManager.INSTANCE.lastUninstallFailed = false;
        } else if (ArtemisSecurityManager.isInstalled()) {
            // empty if block
        }
        if (LOG.isInfoEnabled()) {
            LOG.info("Request install with {}", (Object)configuration.shortDesc());
        }
        String token = INSTANCE.generateAccessToken();
        ArtemisSecurityManager.INSTANCE.blockThreadCreation = false;
        ArtemisSecurityManager.INSTANCE.configuration = Objects.requireNonNull(configuration);
        INSTANCE.unwhitelistThreads();
        if (!ArtemisSecurityManager.isInstalled()) {
            System.setSecurityManager(INSTANCE);
        }
        ArtemisSecurityManager.INSTANCE.isActive = true;
        return token;
    }

    public static synchronized void uninstall(String accessToken) {
        if (!ArtemisSecurityManager.isInstalled()) {
            throw new IllegalStateException(Messages.localized("security.not_installed"));
        }
        Object[] active = new Thread[]{};
        int oldPrio = Thread.currentThread().getPriority();
        try {
            INSTANCE.checkAccess(accessToken);
            if (ArtemisSecurityManager.INSTANCE.isPartlyDisabled) {
                throw new IllegalStateException(Messages.localized("security.already_disabled"));
            }
            Thread.currentThread().setPriority(10);
            LOG.info("Request uninstall");
            System.gc();
            System.runFinalization();
            active = INSTANCE.checkThreadGroup();
            INSTANCE.checkCommonThreadPool();
            INSTANCE.unwhitelistThreads();
            ArtemisSecurityManager.INSTANCE.blockThreadCreation = false;
            ArtemisSecurityManager.INSTANCE.lastUninstallFailed = false;
            ArtemisSecurityManager.INSTANCE.isActive = false;
        }
        catch (Throwable t) {
            ArtemisSecurityManager.INSTANCE.lastUninstallFailed = true;
            LOG.error("UNINSTALL FAILED", t);
            throw t;
        }
        finally {
            Thread.currentThread().setPriority(oldPrio);
        }
        if (active.length > 0) {
            throw new IllegalStateException(Messages.formatLocalized("security.error_threads_still_active", Arrays.toString(active)));
        }
    }

    public static synchronized void configure(String accessToken, ArtemisSecurityConfiguration configuration) {
        INSTANCE.checkAccess(accessToken);
        ArtemisSecurityManager.INSTANCE.configuration = configuration;
    }

    public static synchronized void requestThreadWhitelisting(Thread t) {
        INSTANCE.whitelistThread(t);
    }

    public static synchronized void revokeThreadWhitelisting() {
        if (INSTANCE.isCurrentThreadWhitelisted()) {
            INSTANCE.unwhitelistThreads();
        }
    }

    private static String hash(String s) {
        if (s == null) {
            return "";
        }
        return Base64.getEncoder().encodeToString(SHA256.digest(s.getBytes(StandardCharsets.UTF_8)));
    }

    public static BiConsumer<String, Object> getOnSuppressedModification() {
        return ON_SUPPRESSED_MOD;
    }

    static {
        try {
            SHA256 = MessageDigest.getInstance("SHA-256");
        }
        catch (NoSuchAlgorithmException e) {
            throw new ExceptionInInitializerError(e);
        }
        Messages.init();
        System.setSecurityManager(INSTANCE);
        ForkJoinPool.commonPool();
        ArtemisSecurityManager.INSTANCE.isPartlyDisabled = true;
        System.setSecurityManager(ORIGINAL);
        ArtemisSecurityManager.INSTANCE.isPartlyDisabled = false;
        if (!Objects.equals("main", SecurityConstants.MAIN_THREAD.getName())) {
            LOG.error("Expected ArtemisSecurityManager to be initialized in the main thread but was {}. Exiting...", (Object)SecurityConstants.MAIN_THREAD);
            System.exit(1);
        }
        ON_SUPPRESSED_MOD = (method, object) -> LOG.warn("addSuppressed, {} called with {}", method, object == null ? "null" : object.getClass());
    }
}

