/*
 * Decompiled with CFR 0.152.
 */
package de.tum.in.test.api.dynamic;

import de.tum.in.test.api.dynamic.Check;
import de.tum.in.test.api.dynamic.Checkable;
import de.tum.in.test.api.dynamic.DynamicConstructor;
import de.tum.in.test.api.dynamic.DynamicField;
import de.tum.in.test.api.dynamic.DynamicMethod;
import de.tum.in.test.api.localization.Messages;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apiguardian.api.API;

@API(status=API.Status.MAINTAINED)
public class DynamicClass<T>
implements Checkable {
    private static final Map<Class<?>, Class<?>> primitiveWrappers = Map.of(Boolean.TYPE, Boolean.class, Byte.TYPE, Byte.class, Character.TYPE, Character.class, Short.TYPE, Short.class, Integer.TYPE, Integer.class, Long.TYPE, Long.class, Float.TYPE, Float.class, Double.TYPE, Double.class);
    private final String name;
    private Class<T> clazz;

    private DynamicClass(Class<T> clazz) {
        this.name = clazz.getCanonicalName();
        this.clazz = clazz;
    }

    public DynamicClass(String cName) {
        this.name = Objects.requireNonNull(cName);
    }

    public String getName() {
        if (this.clazz != null) {
            return this.clazz.getCanonicalName();
        }
        return this.name;
    }

    public Class<T> toClass() {
        if (this.clazz == null) {
            try {
                this.clazz = Class.forName(this.name);
            }
            catch (ClassNotFoundException e) {
                throw Messages.localizedFailure(e, "dynamics.class.not_found", this.name);
            }
        }
        return this.clazz;
    }

    @Override
    public boolean exists() {
        if (this.clazz == null) {
            try {
                this.clazz = Class.forName(this.name);
            }
            catch (Exception e) {
                return false;
            }
        }
        return true;
    }

    public boolean isClass(Object classOrStringOrDynamicClass) {
        if (classOrStringOrDynamicClass == null) {
            throw new NullPointerException("Internal Test Error, isClass supplied with null");
        }
        if (classOrStringOrDynamicClass instanceof String) {
            return this.name.equals(classOrStringOrDynamicClass);
        }
        if (classOrStringOrDynamicClass instanceof Class) {
            if (this.clazz != null) {
                return this.clazz.equals(classOrStringOrDynamicClass);
            }
            return this.name.equals(((Class)classOrStringOrDynamicClass).getCanonicalName());
        }
        if (classOrStringOrDynamicClass instanceof DynamicClass) {
            return this.name.equals(((DynamicClass)classOrStringOrDynamicClass).name);
        }
        throw new IllegalArgumentException("Internal Test Error, isClass supplied with " + classOrStringOrDynamicClass.getClass());
    }

    public T cast(Object obj) {
        Class<T> rClass = this.toClass();
        if (rClass.equals(Void.TYPE) && obj == null) {
            return null;
        }
        if (rClass.isPrimitive()) {
            Class<?> wrapper;
            if (obj == null) {
                throw new NullPointerException(Messages.localized("dynamics.class.null", this.getName()));
            }
            Class<?> objClass = obj.getClass();
            if (objClass.equals(wrapper = primitiveWrappers.get(rClass))) {
                return (T)obj;
            }
        }
        return rClass.cast(obj);
    }

    public DynamicConstructor<T> constructor(Object ... dynamicableParams) {
        return new DynamicConstructor(this, dynamicableParams);
    }

    public <R> DynamicMethod<R> method(DynamicClass<R> returnType, String name, Object ... dynamicableParams) {
        return new DynamicMethod<R>(this, returnType, name, dynamicableParams);
    }

    public <R> DynamicMethod<R> method(Class<R> returnType, String name, Object ... dynamicableParams) {
        return new DynamicMethod<R>(this, returnType, name, dynamicableParams);
    }

    public <R> DynamicField<R> field(DynamicClass<R> type, String ... possibleNames) {
        return new DynamicField<R>(this, type, true, possibleNames);
    }

    public <R> DynamicField<R> field(Class<R> type, String ... possibleNames) {
        return new DynamicField<R>(this, type, true, possibleNames);
    }

    public static <T> DynamicClass<T> toDynamic(Class<T> clazz) {
        return new DynamicClass<T>(Objects.requireNonNull(clazz, "class must not be null"));
    }

    public static DynamicClass<?> toDynamic(Object classOrStringOrDynamicClass) {
        if (classOrStringOrDynamicClass == null) {
            throw new NullPointerException("Internal Test Error, toDynamic supplied with null");
        }
        if (classOrStringOrDynamicClass instanceof String) {
            return new DynamicClass((String)classOrStringOrDynamicClass);
        }
        if (classOrStringOrDynamicClass instanceof Class) {
            return DynamicClass.toDynamic((Class)classOrStringOrDynamicClass);
        }
        if (classOrStringOrDynamicClass instanceof DynamicClass) {
            return (DynamicClass)classOrStringOrDynamicClass;
        }
        throw new IllegalArgumentException("Internal Test Error, toDynamic supplied with " + classOrStringOrDynamicClass.getClass());
    }

    public static DynamicClass<?>[] toDynamic(Object[] classesOrStringsOrDynamicClasses) {
        DynamicClass[] dynamicClasses = new DynamicClass[classesOrStringsOrDynamicClasses.length];
        for (int i = 0; i < dynamicClasses.length; ++i) {
            dynamicClasses[i] = DynamicClass.toDynamic(classesOrStringsOrDynamicClasses[i]);
        }
        return dynamicClasses;
    }

    public static Class<?>[] resolveAll(DynamicClass<?>[] dynamicClasses) {
        Class[] classes = new Class[dynamicClasses.length];
        for (int i = 0; i < classes.length; ++i) {
            int x = i;
            classes[x] = Objects.requireNonNull(dynamicClasses[i].toClass(), () -> dynamicClasses[x] + " could not be resolved");
        }
        return classes;
    }

    public String toString() {
        return this.name;
    }

    @Override
    public void check(Check ... checks) {
        this.toClass();
        int modifiers = this.toClass().getModifiers();
        for (Check check : checks) {
            check.checkModifiers(modifiers, () -> Messages.localized("dynamics.class.name", this));
        }
    }

    public int checkForPublicOrProtectedMethods(DynamicMethod<?> ... exceptions) {
        return this.checkForPublicOrProtectedMethods(List.of(exceptions));
    }

    public int checkForPublicOrProtectedMethods(List<DynamicMethod<?>> exceptions) {
        int checked = 0;
        Set<String> publicMethods = Set.of(DynamicMethod.signatureOfAll(exceptions));
        Set<String> objectMethods = Set.of(DynamicMethod.signatureOfAll(Object.class.getMethods()));
        for (Method m : this.toClass().getDeclaredMethods()) {
            String sig;
            if (m.isSynthetic() || m.isBridge()) continue;
            if (Modifier.isPublic(m.getModifiers()) && !"main(java.lang.String[])".endsWith(sig = DynamicMethod.signatureOf(m)) && !publicMethods.contains(sig) && !objectMethods.contains(sig)) {
                throw Messages.localizedFailure("dynamics.class.method_public", sig);
            }
            if (Modifier.isProtected(m.getModifiers()) && !objectMethods.contains(sig = DynamicMethod.signatureOf(m))) {
                throw Messages.localizedFailure("dynamics.class.method_protected", sig);
            }
            ++checked;
        }
        return checked;
    }

    public int checkForNonPrivateFields() {
        int checked = 0;
        for (Field f : this.toClass().getDeclaredFields()) {
            if (f.isSynthetic()) continue;
            if (!Modifier.isPrivate(f.getModifiers())) {
                throw Messages.localizedFailure("dynamics.class.field_private", f);
            }
            ++checked;
        }
        return checked;
    }

    public int checkForNonFinalFields() {
        int checked = 0;
        for (Field f : this.toClass().getDeclaredFields()) {
            if (f.isSynthetic()) continue;
            if (!Modifier.isFinal(f.getModifiers())) {
                throw Messages.localizedFailure("dynamics.class.field_final", f);
            }
            ++checked;
        }
        return checked;
    }
}

