/*
 * Decompiled with CFR 0.152.
 */
package de.tum.in.test.api.io;

import de.tum.in.test.api.io.AbstractLine;
import de.tum.in.test.api.io.Line;
import de.tum.in.test.api.io.LineProvider;
import de.tum.in.test.api.localization.Messages;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apiguardian.api.API;

@API(status=API.Status.STABLE)
public final class InputTester
implements LineProvider {
    private final List<Line> expectedInput = new ArrayList<Line>();
    private int position;

    @Override
    public Line getNextLine() {
        if (this.hasNextLine()) {
            return this.expectedInput.get(this.position++);
        }
        if (this.expectedInput.isEmpty()) {
            throw new IllegalStateException(Messages.localized("input_tester.no_input_expected", new Object[0]));
        }
        throw new IllegalStateException(Messages.localized("input_tester.no_more_input_expected", this.getCurrentLine()));
    }

    Line getCurrentLine() {
        return this.expectedInput.get(this.position - 1);
    }

    private void addExpectedLine(AbstractLine line) {
        this.expectedInput.add(line);
        line.setLineNumber(this.expectedInput.size());
    }

    @Override
    public boolean hasNextLine() {
        return this.position < this.expectedInput.size();
    }

    public void addLinesToInput(String ... lines) {
        Arrays.stream(lines).map(Line::of).forEach(this::addExpectedLine);
    }

    public void resetInput() {
        this.expectedInput.clear();
        this.position = 0;
    }
}

