/*
 * Decompiled with CFR 0.152.
 */
package de.tum.in.test.api.util;

import de.tum.in.test.api.localization.Messages;
import de.tum.in.test.api.util.ClassMemberAccessor;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.StringJoiner;
import org.apiguardian.api.API;
import org.opentest4j.AssertionFailedError;

@API(status=API.Status.STABLE)
public final class ReflectionTestUtils {
    private ReflectionTestUtils() {
    }

    public static Class<?> getClazz(String qualifiedClassName) {
        String[] qualifiedClassNameSegments = qualifiedClassName.split("\\.");
        String className = qualifiedClassNameSegments[qualifiedClassNameSegments.length - 1];
        try {
            return Class.forName(qualifiedClassName);
        }
        catch (ClassNotFoundException e) {
            throw Messages.localizedFailure("reflection_test_utils.class_not_found", className);
        }
        catch (ExceptionInInitializerError e) {
            throw Messages.localizedFailure("reflection_test_utils.class_initialization", className);
        }
    }

    public static Object newInstance(String qualifiedClassName, Object ... constructorArgs) {
        return ReflectionTestUtils.newInstance(ReflectionTestUtils.getClazz(qualifiedClassName), constructorArgs);
    }

    public static Object newInstanceFromNonPublicConstructor(String qualifiedClassName, Object ... constructorArgs) {
        return ReflectionTestUtils.newInstanceFromNonPublicConstructor(ReflectionTestUtils.getClazz(qualifiedClassName), constructorArgs);
    }

    public static Object newInstance(Class<?> clazz, Object ... constructorArgs) {
        return ReflectionTestUtils.newInstanceAccessible(clazz, false, constructorArgs);
    }

    public static Object newInstanceFromNonPublicConstructor(Class<?> clazz, Object ... constructorArgs) {
        return ReflectionTestUtils.newInstanceAccessible(clazz, true, constructorArgs);
    }

    public static Object newInstance(Constructor<?> constructor, Object ... constructorArgs) {
        return ReflectionTestUtils.newInstanceAccessible(constructor, false, constructorArgs);
    }

    public static Object newInstanceFromNonPublicConstructor(Constructor<?> constructor, Object ... constructorArgs) {
        return ReflectionTestUtils.newInstanceAccessible(constructor, true, constructorArgs);
    }

    private static Object newInstanceAccessible(Class<?> clazz, boolean forceAccess, Object[] constructorArgs) {
        Class<?>[] constructorArgTypes = ReflectionTestUtils.getParameterTypes(constructorArgs, "reflection_test_utils.constructor_null_args", clazz.getSimpleName());
        try {
            Constructor<?> constructor = clazz.getDeclaredConstructor(constructorArgTypes);
            return ReflectionTestUtils.newInstanceAccessible(constructor, forceAccess, constructorArgs);
        }
        catch (NoSuchMethodException nsme) {
            throw Messages.localizedFailure("reflection_test_utils.constructor_not_found_args", clazz.getSimpleName(), ReflectionTestUtils.getParameterTypesAsString(constructorArgTypes));
        }
    }

    private static Object newInstanceAccessible(Constructor<?> constructor, boolean forceAccess, Object[] constructorArgs) {
        try {
            if (forceAccess) {
                constructor.setAccessible(true);
            }
            return constructor.newInstance(constructorArgs);
        }
        catch (IllegalAccessException iae) {
            throw Messages.localizedFailure("reflection_test_utils.constructor_access", constructor.getDeclaringClass().getSimpleName(), ReflectionTestUtils.getParameterTypesAsString(constructor.getParameterTypes()));
        }
        catch (IllegalArgumentException iae) {
            throw Messages.localizedFailure("reflection_test_utils.constructor_arguments", constructor.getDeclaringClass().getSimpleName(), ReflectionTestUtils.getParameterTypesAsString(constructor.getParameterTypes()));
        }
        catch (InstantiationException ie) {
            throw Messages.localizedFailure("reflection_test_utils.constructor_abstract_class", constructor.getDeclaringClass().getSimpleName());
        }
        catch (InvocationTargetException ite) {
            throw Messages.localizedFailure("reflection_test_utils.constructor_internal_exception", constructor.getDeclaringClass().getSimpleName(), constructorArgs.length);
        }
        catch (ExceptionInInitializerError eiie) {
            throw Messages.localizedFailure("reflection_test_utils.constructor_class_init", constructor.getDeclaringClass().getSimpleName(), constructorArgs.length);
        }
    }

    public static Object valueForAttribute(Object object, String attributeName) {
        return ReflectionTestUtils.valueForAttribute(object, attributeName, false);
    }

    public static Object valueForNonPublicAttribute(Object object, String attributeName) {
        return ReflectionTestUtils.valueForAttribute(object, attributeName, true);
    }

    private static Object valueForAttribute(Object object, String attributeName, boolean forceAccess) {
        ReflectionTestUtils.requireNonNull(object, "reflection_test_utils.attribute_null", attributeName);
        try {
            Field field = ClassMemberAccessor.getField(object.getClass(), attributeName, forceAccess);
            if (forceAccess) {
                field.setAccessible(true);
            }
            return field.get(object);
        }
        catch (NoSuchFieldException nsfe) {
            throw Messages.localizedFailure("reflection_test_utils.attribute_not_found", attributeName, object.getClass().getSimpleName());
        }
        catch (IllegalAccessException iae) {
            throw Messages.localizedFailure("reflection_test_utils.attribute_access", attributeName, object.getClass().getSimpleName());
        }
    }

    public static Method getMethod(Object object, String methodName, Class<?> ... parameterTypes) {
        ReflectionTestUtils.requireNonNull(object, "reflection_test_utils.method_null_target", methodName);
        return ReflectionTestUtils.getMethod(object.getClass(), methodName, parameterTypes);
    }

    public static Method getMethod(Class<?> declaringClass, String methodName, Class<?> ... parameterTypes) {
        return ReflectionTestUtils.getMethodAccessible(declaringClass, methodName, false, parameterTypes);
    }

    public static Method getNonPublicMethod(Object object, String methodName, Class<?> ... parameterTypes) {
        ReflectionTestUtils.requireNonNull(object, "reflection_test_utils.method_null_target", methodName);
        return ReflectionTestUtils.getNonPublicMethod(object.getClass(), methodName, parameterTypes);
    }

    public static Method getNonPublicMethod(Class<?> declaringClass, String methodName, Class<?> ... parameterTypes) {
        return ReflectionTestUtils.getMethodAccessible(declaringClass, methodName, true, parameterTypes);
    }

    private static Method getMethodAccessible(Class<?> declaringClass, String methodName, boolean findNonPublic, Class<?>[] parameterTypes) {
        try {
            return ClassMemberAccessor.getMethod(declaringClass, methodName, findNonPublic, parameterTypes);
        }
        catch (NoSuchMethodException nsme) {
            throw Messages.localizedFailure("reflection_test_utils.method_not_found", methodName, ReflectionTestUtils.describeParameters(parameterTypes), declaringClass.getSimpleName());
        }
        catch (NullPointerException npe) {
            throw Messages.localizedFailure("reflection_test_utils.method_name_null", methodName, ReflectionTestUtils.describeParameters(parameterTypes), declaringClass.getSimpleName());
        }
    }

    public static Object invokeMethod(Object object, String methodName, Object ... params) {
        return ReflectionTestUtils.invokeMethodAccessible(object, methodName, false, params);
    }

    public static Object invokeNonPublicMethod(Object object, String methodName, Object ... params) {
        return ReflectionTestUtils.invokeMethodAccessible(object, methodName, true, params);
    }

    public static Object invokeMethod(Object object, Method method, Object ... params) {
        return ReflectionTestUtils.invokeMethodAccessible(object, method, false, params);
    }

    public static Object invokeNonPublicMethod(Object object, Method method, Object ... params) {
        return ReflectionTestUtils.invokeMethodAccessible(object, method, true, params);
    }

    private static Object invokeMethodAccessible(Object object, String methodName, boolean forceAccess, Object[] params) {
        Class<?>[] parameterTypes = ReflectionTestUtils.getParameterTypes(params, "reflection_test_utils.method_null_args", methodName);
        Method method = ReflectionTestUtils.getMethodAccessible(object.getClass(), methodName, forceAccess, parameterTypes);
        return ReflectionTestUtils.invokeMethodAccessible(object, method, forceAccess, params);
    }

    private static Object invokeMethodAccessible(Object object, Method method, boolean forceAccess, Object[] params) {
        try {
            return ReflectionTestUtils.invokeMethodRethrowingAccessible(object, method, forceAccess, params);
        }
        catch (AssertionFailedError e) {
            throw e;
        }
        catch (Throwable e) {
            throw Messages.localizedFailure("reflection_test_utils.method_internal_exception", method.getName(), method.getDeclaringClass().getSimpleName(), e);
        }
    }

    public static Object invokeMethodRethrowing(Object object, Method method, Object ... params) throws Throwable {
        return ReflectionTestUtils.invokeMethodRethrowingAccessible(object, method, false, params);
    }

    public static Object invokeNonPublicMethodRethrowing(Object object, Method method, Object ... params) throws Throwable {
        return ReflectionTestUtils.invokeMethodRethrowingAccessible(object, method, true, params);
    }

    private static Object invokeMethodRethrowingAccessible(Object object, Method method, boolean forceAccess, Object[] params) throws Throwable {
        try {
            if (forceAccess) {
                method.setAccessible(true);
            }
            return method.invoke(object, params);
        }
        catch (IllegalAccessException iae) {
            throw Messages.localizedFailure("reflection_test_utils.method_access", method.getName(), method.getDeclaringClass().getSimpleName());
        }
        catch (IllegalArgumentException iae) {
            throw Messages.localizedFailure("reflection_test_utils.method_parameters", method.getName(), method.getDeclaringClass().getSimpleName());
        }
        catch (NullPointerException e) {
            throw Messages.localizedFailure("reflection_test_utils.method_null_target_instance", method.getName(), method.getDeclaringClass().getSimpleName());
        }
        catch (ExceptionInInitializerError e) {
            throw Messages.localizedFailure("reflection_test_utils.method_class_init", method.getName(), method.getDeclaringClass().getSimpleName());
        }
        catch (InvocationTargetException e) {
            throw e.getCause();
        }
    }

    public static <T> Constructor<T> getConstructor(Class<T> declaringClass, Class<?> ... parameterTypes) {
        try {
            return declaringClass.getConstructor(parameterTypes);
        }
        catch (NoSuchMethodException nsme) {
            throw Messages.localizedFailure("reflection_test_utils.constructor_not_found_params", ReflectionTestUtils.describeParameters(parameterTypes), declaringClass.getSimpleName());
        }
    }

    private static String describeParameters(Class<?> ... parameterTypes) {
        if (parameterTypes.length == 0) {
            return Messages.localized("reflection_test_utils.no_parameters", new Object[0]);
        }
        return Messages.localized("reflection_test_utils.with_parameters", ReflectionTestUtils.getParameterTypesAsString(parameterTypes));
    }

    private static Class<?>[] getParameterTypes(Object[] params, String key, Object ... messageArgs) {
        return (Class[])Arrays.stream(params).map(it -> ReflectionTestUtils.requireNonNull(it, key, messageArgs)).map(Object::getClass).toArray(Class[]::new);
    }

    private static String getParameterTypesAsString(Class<?> ... parameterTypes) {
        StringJoiner joiner = new StringJoiner(", ", "[ ", " ]");
        joiner.setEmptyValue("none");
        Arrays.stream(parameterTypes).map(type -> ReflectionTestUtils.requireNonNull(type, "One of the supplied types was null.", new Object[0])).map(Class::getSimpleName).forEach(joiner::add);
        return joiner.toString();
    }

    private static <T> T requireNonNull(T object, String key, Object ... messageArgs) {
        if (object == null) {
            throw Messages.localizedFailure(key, messageArgs);
        }
        return object;
    }
}

