/*
 * Decompiled with CFR 0.152.
 */
package de.tum.in.test.api.ast.asserting;

import com.github.javaparser.ParserConfiguration;
import com.github.javaparser.StaticJavaParser;
import de.tum.in.test.api.ast.model.UnwantedNode;
import de.tum.in.test.api.ast.type.Type;
import de.tum.in.test.api.localization.Messages;
import de.tum.in.test.api.util.ProjectSourcesFinder;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Objects;
import java.util.Optional;
import org.apiguardian.api.API;
import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.Assertions;

@API(status=API.Status.MAINTAINED)
public class UnwantedNodesAssert
extends AbstractAssert<UnwantedNodesAssert, Path> {
    private final ParserConfiguration.LanguageLevel level;

    private UnwantedNodesAssert(Path path, ParserConfiguration.LanguageLevel level) {
        super((Object)Objects.requireNonNull(path), UnwantedNodesAssert.class);
        this.level = level;
        if (!Files.isDirectory(path, new LinkOption[0])) {
            Assertions.fail((String)"The source directory %s does not exist", (Object[])new Object[]{path});
        }
    }

    public static UnwantedNodesAssert assertThatProjectSources() {
        Path path = ProjectSourcesFinder.findProjectSourcesPath().orElseThrow(() -> new AssertionError((Object)"Could not find project sources folder. Make sure the build file is configured correctly. If it is not located in the execution folder directly, set the location using AresConfiguration methods."));
        return new UnwantedNodesAssert(path, null);
    }

    public static UnwantedNodesAssert assertThatSourcesIn(Path directory) {
        Objects.requireNonNull(directory, "The given source path must not be null.");
        return new UnwantedNodesAssert(directory, null);
    }

    public UnwantedNodesAssert withinPackage(String packageName) {
        Objects.requireNonNull(packageName, "The package name must not be null.");
        Path newPath = ((Path)this.actual).resolve(Path.of("", packageName.split("\\.")));
        return new UnwantedNodesAssert(newPath, this.level);
    }

    public UnwantedNodesAssert withLanguageLevel(ParserConfiguration.LanguageLevel level) {
        return new UnwantedNodesAssert((Path)this.actual, level);
    }

    public UnwantedNodesAssert hasNo(Type type) {
        if (this.level == null) {
            this.failWithMessage("The 'level' is not set. Please use UnwantedNodesAssert.withLanguageLevel(LanguageLevel).", new Object[0]);
        }
        StaticJavaParser.getParserConfiguration().setLanguageLevel(this.level);
        Optional<String> errorMessage = UnwantedNode.getMessageForUnwantedNodesForAllFilesBelow((Path)this.actual, type.getNodeNameNodeMap());
        errorMessage.ifPresent(unwantedNodeMessageForAllJavaFiles -> this.failWithMessage(Messages.localized("ast.method.has_no", new Object[0]) + System.lineSeparator() + unwantedNodeMessageForAllJavaFiles, new Object[0]));
        return this;
    }
}

