/*
 * Decompiled with CFR 0.152.
 */
package de.tum.in.test.api.jupiter;

import de.tum.in.test.api.context.TestContext;
import de.tum.in.test.api.context.TestContextUtils;
import de.tum.in.test.api.context.TestType;
import de.tum.in.test.api.jupiter.JupiterAresTest;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Stream;
import org.apiguardian.api.API;
import org.junit.jupiter.api.extension.ExtensionContext;

@API(status=API.Status.INTERNAL)
public class JupiterContext
extends TestContext {
    private final ExtensionContext extensionContext;

    JupiterContext(ExtensionContext extensionContext) {
        this.extensionContext = extensionContext;
    }

    @Override
    public Optional<Method> testMethod() {
        return this.findOptionalsInHierarchy(ExtensionContext::getTestMethod).findFirst();
    }

    @Override
    public Optional<Class<?>> testClass() {
        return this.findOptionalsInHierarchy(ExtensionContext::getTestClass).findFirst();
    }

    @Override
    public Optional<Object> testInstance() {
        return this.findOptionalsInHierarchy(ExtensionContext::getTestInstance).findFirst();
    }

    @Override
    public Optional<AnnotatedElement> annotatedElement() {
        return this.findOptionalsInHierarchy(ExtensionContext::getElement).findFirst();
    }

    @Override
    public Optional<String> displayName() {
        return Optional.of(this.extensionContext.getDisplayName());
    }

    @Override
    public Optional<TestType> findTestType() {
        return TestContextUtils.findAnnotationIn(this, JupiterAresTest.class).map(JupiterAresTest::value);
    }

    public ExtensionContext getExtensionContext() {
        return this.extensionContext;
    }

    private <T> Stream<T> findOptionalsInHierarchy(Function<ExtensionContext, Optional<T>> getter) {
        return this.hierarchy().map(getter).filter(Optional::isPresent).map(Optional::get);
    }

    private Stream<ExtensionContext> hierarchy() {
        return Stream.iterate(this.extensionContext, Objects::nonNull, ec -> ec.getParent().orElse(null));
    }

    public static JupiterContext of(ExtensionContext extensionContext) {
        return new JupiterContext(extensionContext);
    }
}

