/*
 * Decompiled with CFR 0.152.
 */
package de.tum.in.test.api.security;

import de.tum.in.test.api.TestUtils;
import de.tum.in.test.api.internal.BlacklistedInvoker;
import java.io.PrintStream;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apiguardian.api.API;

@API(status=API.Status.INTERNAL)
public final class SecurityConstants {
    static final PrintStream SYSTEM_OUT = System.out;
    static final PrintStream SYSTEM_ERR = System.err;
    static final Thread WORKER_THREAD = Thread.currentThread();
    static final ThreadGroup MAIN_THREAD_GROUP;
    private static final Set<String> USER_DEFINED_STACK_WHITELIST;
    static final String SECURITY_PACKAGE_NAME;
    private static final Set<String> STATIC_STACK_WHITELIST;
    static final Set<String> STACK_WHITELIST;
    static final Set<String> STACK_BLACKLIST;
    static final Set<String> PACKAGE_USE_BLACKLIST;

    private SecurityConstants() {
    }

    static {
        ThreadGroup rootThreadGroup = TestUtils.getRootThreadGroup();
        ThreadGroup[] threadGroups = new ThreadGroup[rootThreadGroup.activeGroupCount() + 10];
        rootThreadGroup.enumerate(threadGroups, true);
        MAIN_THREAD_GROUP = Stream.of(threadGroups).filter(Objects::nonNull).filter(threadGroup -> "main".equals(threadGroup.getName())).findFirst().orElse(null);
        String additionalTurstedPackages = System.getProperty("ares.security.trustedpackages");
        USER_DEFINED_STACK_WHITELIST = additionalTurstedPackages != null ? Stream.of(additionalTurstedPackages.split(",")).filter(Predicate.not(String::isBlank)).collect(Collectors.toUnmodifiableSet()) : Set.of();
        SECURITY_PACKAGE_NAME = SecurityConstants.class.getPackageName();
        STATIC_STACK_WHITELIST = Set.of("java.", "org.junit.", "jdk.", "org.eclipse.", "com.intellij", "org.assertj", "org.opentest4j.", "com.sun.", "sun.", "org.apache.", "de.tum.in.test.api", "net.jqwik.", "ch.qos.logback", "org.jacoco", "javax.", "org.json", "org.gradle", "worker.org.gradle", "com.github.javaparser");
        STACK_WHITELIST = Stream.concat(STATIC_STACK_WHITELIST.stream(), USER_DEFINED_STACK_WHITELIST.stream()).collect(Collectors.toUnmodifiableSet());
        STACK_BLACKLIST = Set.of(BlacklistedInvoker.class.getName(), "org.junit.platform.commons.util.ReflectionUtils.getUnderlyingCause");
        PACKAGE_USE_BLACKLIST = Set.of(SECURITY_PACKAGE_NAME, "de.tum.in.test.api.internal", "jdk.internal", "sun.");
    }
}

