/*
 * Decompiled with CFR 0.152.
 */
package de.tum.in.test.api.ast.model;

import com.github.javaparser.StaticJavaParser;
import com.github.javaparser.ast.CompilationUnit;
import de.tum.in.test.api.localization.Messages;
import java.io.IOException;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apiguardian.api.API;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@API(status=API.Status.INTERNAL)
public class JavaFile {
    private static final PathMatcher JAVAFILEMATCHER = FileSystems.getDefault().getPathMatcher("glob:*.java");
    private static final Logger LOG = LoggerFactory.getLogger(JavaFile.class);
    private final Path javaFilePath;
    private final CompilationUnit javaFileAST;

    public JavaFile(Path javaFilePath, CompilationUnit javaFileAST) {
        this.javaFilePath = javaFilePath;
        this.javaFileAST = javaFileAST;
    }

    public Path getJavaFilePath() {
        return this.javaFilePath;
    }

    public CompilationUnit getJavaFileAST() {
        return this.javaFileAST;
    }

    public static JavaFile convertFromFile(Path pathOfFile) {
        if (!JAVAFILEMATCHER.matches(pathOfFile.getFileName())) {
            return null;
        }
        try {
            return new JavaFile(pathOfFile, StaticJavaParser.parse((Path)pathOfFile));
        }
        catch (IOException e) {
            LOG.error("Error reading Java file '{}'", (Object)pathOfFile.toAbsolutePath(), (Object)e);
            throw new AssertionError((Object)Messages.localized("ast.method.convert_from_file", pathOfFile.toAbsolutePath()));
        }
    }

    public static List<JavaFile> readFromDirectory(Path pathOfDirectory) {
        List<JavaFile> list;
        block8: {
            Stream<Path> directoryContentStream = Files.walk(pathOfDirectory, new FileVisitOption[0]);
            try {
                list = directoryContentStream.map(JavaFile::convertFromFile).filter(Objects::nonNull).collect(Collectors.toList());
                if (directoryContentStream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (directoryContentStream != null) {
                        try {
                            directoryContentStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    LOG.error("Error reading Java files in '{}'", (Object)pathOfDirectory.toAbsolutePath(), (Object)e);
                    throw new AssertionError((Object)Messages.localized("ast.method.read_from_directory", pathOfDirectory.toAbsolutePath()));
                }
            }
            directoryContentStream.close();
        }
        return list;
    }
}

