/*
 * Decompiled with CFR 0.152.
 */
package de.tum.in.test.api.security;

import de.tum.in.test.api.TrustedThreads;
import de.tum.in.test.api.context.TestContext;
import de.tum.in.test.api.localization.Messages;
import de.tum.in.test.api.security.AresSecurityConfiguration;
import de.tum.in.test.api.security.ConfigurationException;
import de.tum.in.test.api.security.SecurityConstants;
import de.tum.in.test.api.util.PackageRule;
import de.tum.in.test.api.util.PathRule;
import java.io.IOException;
import java.lang.reflect.Method;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apiguardian.api.API;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@API(status=API.Status.INTERNAL)
public final class AresSecurityConfigurationBuilder {
    private static final Logger LOG = LoggerFactory.getLogger(AresSecurityConfigurationBuilder.class);
    private static final Path EXPECTED_MAVEN_POM_PATH = Path.of(System.getProperty("ares.maven.pom", "pom.xml"), new String[0]);
    private static final Path EXPECTED_GRADLE_BUILD_PATH = Path.of(System.getProperty("ares.gradle.build", "build.gradle"), new String[0]);
    private static final String MAVEN_ENFORCER_FILE_ENTRY = "<file>${project.build.outputDirectory}%s</file>";
    private static final String GRADLE_ENFORCER_FILE_ENTRY = "\"$studentOutputDir%s\"";
    private static final boolean IS_MAVEN = (StackWalker.getInstance().walk(sfs -> sfs.anyMatch(sf -> sf.getClassName().contains("maven"))) != false || Files.exists(EXPECTED_MAVEN_POM_PATH, new LinkOption[0])) && !Boolean.getBoolean("ares.maven.ignore");
    private static final boolean IS_GRADLE = (StackWalker.getInstance().walk(sfs -> sfs.anyMatch(sf -> sf.getClassName().contains("gradle"))) != false || Files.exists(EXPECTED_GRADLE_BUILD_PATH, new LinkOption[0])) && !Boolean.getBoolean("ares.gradle.ignore");
    private static String buildConfigurationFileContent;
    private Optional<Class<?>> testClass = Optional.empty();
    private Optional<Method> testMethod = Optional.empty();
    private Path executionPath;
    private Set<String> whitelistedClassNames = new HashSet<String>();
    private Set<PathRule> whitelistedPaths;
    private Set<PathRule> blacklistedPaths = Set.of();
    private Set<PackageRule> blacklistedPackages = Set.of();
    private Set<PackageRule> whitelistedPackages = Set.of();
    private Set<Integer> allowedLocalPorts = Set.of();
    private OptionalInt allowLocalPortsAbove = OptionalInt.empty();
    private Set<Integer> excludedLocalPorts = Set.of();
    private OptionalInt allowedThreadCount = OptionalInt.empty();
    private Set<PackageRule> trustedPackages = Set.of();
    private TrustedThreads.TrustScope threadTrustScope = TrustedThreads.TrustScope.MINIMAL;

    private AresSecurityConfigurationBuilder() {
    }

    public AresSecurityConfigurationBuilder withPath(Path executionPath) {
        this.executionPath = Objects.requireNonNull(executionPath);
        return this;
    }

    public AresSecurityConfigurationBuilder withPathWhitelist(Collection<PathRule> whitelistedPaths) {
        this.whitelistedPaths = Set.copyOf(whitelistedPaths);
        return this;
    }

    public AresSecurityConfigurationBuilder withPathBlacklist(Collection<PathRule> blacklistedPaths) {
        this.blacklistedPaths = Set.copyOf(blacklistedPaths);
        return this;
    }

    public AresSecurityConfigurationBuilder withAllowedLocalPorts(Set<Integer> allowedLocalPorts) {
        this.allowedLocalPorts = Objects.requireNonNull(allowedLocalPorts);
        return this;
    }

    public AresSecurityConfigurationBuilder withAllowLocalPortsAbove(OptionalInt allowLocalPortsAbove) {
        this.allowLocalPortsAbove = Objects.requireNonNull(allowLocalPortsAbove);
        return this;
    }

    public AresSecurityConfigurationBuilder withExcludedLocalPorts(Set<Integer> excludedLocalPorts) {
        this.excludedLocalPorts = Objects.requireNonNull(excludedLocalPorts);
        return this;
    }

    public AresSecurityConfigurationBuilder withAllowedThreadCount(OptionalInt allowedThreadCount) {
        this.allowedThreadCount = Objects.requireNonNull(allowedThreadCount);
        return this;
    }

    public AresSecurityConfigurationBuilder configureFromContext(TestContext context) {
        this.testClass = Objects.requireNonNull(context.testClass());
        this.testMethod = Objects.requireNonNull(context.testMethod());
        return this;
    }

    public AresSecurityConfigurationBuilder addWhitelistedClassNames(Collection<String> classNames) {
        this.whitelistedClassNames.addAll(classNames);
        return this;
    }

    public AresSecurityConfigurationBuilder withPackageBlacklist(Collection<PackageRule> packageBlacklist) {
        this.blacklistedPackages = Set.copyOf(packageBlacklist);
        return this;
    }

    public AresSecurityConfigurationBuilder withPackageWhitelist(Collection<PackageRule> packageWhitelist) {
        this.whitelistedPackages = Set.copyOf(packageWhitelist);
        return this;
    }

    public AresSecurityConfigurationBuilder withTrustedPackages(Set<PackageRule> trustedPackages) {
        this.trustedPackages = Set.copyOf(trustedPackages);
        return this;
    }

    public AresSecurityConfigurationBuilder withThreadTrustScope(TrustedThreads.TrustScope threadTrustScope) {
        this.threadTrustScope = Objects.requireNonNull(threadTrustScope);
        return this;
    }

    public AresSecurityConfiguration build() {
        this.validate();
        return new AresSecurityConfiguration(this.testClass, this.testMethod, this.executionPath, this.whitelistedClassNames, Optional.ofNullable(this.whitelistedPaths), this.blacklistedPaths, this.allowedLocalPorts, this.allowLocalPortsAbove, this.excludedLocalPorts, this.allowedThreadCount, this.blacklistedPackages, this.whitelistedPackages, this.trustedPackages, this.threadTrustScope);
    }

    private void validate() {
        if (this.allowedThreadCount.orElse(0) < 0) {
            throw new ConfigurationException(Messages.localized("security.configuration_invalid_negative_threads", new Object[0]));
        }
        if (!Collections.disjoint(this.allowedLocalPorts, this.excludedLocalPorts)) {
            throw new ConfigurationException(Messages.localized("security.configuration_invalid_port_rule_intersection", new Object[0]));
        }
        this.allowedLocalPorts.forEach(AresSecurityConfigurationBuilder::validatePortRange);
        this.excludedLocalPorts.forEach(AresSecurityConfigurationBuilder::validatePortRange);
        this.allowLocalPortsAbove.ifPresent(value -> {
            AresSecurityConfigurationBuilder.validatePortRange(value);
            if (this.allowedLocalPorts.stream().anyMatch(allowed -> allowed > value)) {
                throw new ConfigurationException(Messages.localized("security.configuration_invalid_port_allowed_in_rage", new Object[0]));
            }
            if (this.excludedLocalPorts.stream().anyMatch(exclusion -> exclusion <= value)) {
                throw new ConfigurationException(Messages.localized("security.configuration_invalid_port_exclude_outside_rage", new Object[0]));
            }
        });
        AresSecurityConfigurationBuilder.validateTrustedPackages(this.trustedPackages);
    }

    private static void validatePortRange(int value) {
        if (value < 0) {
            throw new ConfigurationException(Messages.localized("security.configuration_invalid_port_negative", new Object[0]));
        }
        if (value > 65535) {
            throw new ConfigurationException(Messages.localized("security.configuration_invalid_port_over_max", new Object[0]));
        }
    }

    private static void validateTrustedPackages(Set<PackageRule> trustedPackages) {
        Path expectedProjectBuildFilePath;
        String enforcerFileEntryFormat;
        if (IS_MAVEN) {
            enforcerFileEntryFormat = MAVEN_ENFORCER_FILE_ENTRY;
            expectedProjectBuildFilePath = EXPECTED_MAVEN_POM_PATH;
        } else if (IS_GRADLE) {
            enforcerFileEntryFormat = GRADLE_ENFORCER_FILE_ENTRY;
            expectedProjectBuildFilePath = EXPECTED_GRADLE_BUILD_PATH;
        } else {
            return;
        }
        try {
            if (buildConfigurationFileContent == null) {
                buildConfigurationFileContent = Files.readString(expectedProjectBuildFilePath);
            }
            Stream<String> enforcerFileRules = Stream.concat(SecurityConstants.STACK_WHITELIST.stream(), trustedPackages.stream().map(packageRule -> packageRule.getPackagePattern().split("\\*", 2)[0]).filter(Predicate.not(String::isEmpty))).map(packagePrefix -> "/" + String.join((CharSequence)"/", packagePrefix.split("\\.")) + "/").map(packagePath -> String.format(enforcerFileEntryFormat, packagePath));
            List missing = enforcerFileRules.filter(Predicate.not(buildConfigurationFileContent::contains)).sorted().collect(Collectors.toList());
            LOG.debug("Validated build configuration regarding trusted package rules, {} are missing.", (Object)missing.size());
            if (missing.isEmpty()) {
                return;
            }
            throw new ConfigurationException("Ares has detected that the build configuration is probably incomplete. The following file-must-not-exist rules seem to be missing:\n    " + String.join((CharSequence)"\n    ", missing) + "\n    See https://github.com/ls1intum/Ares#what-you-need-to-do-outside-ares for more information.");
        }
        catch (IOException e) {
            LOG.error("Ares cannot read pom.xml", (Throwable)e);
            throw new ConfigurationException("Ares cannot read pom.xml and validate the configuration. Please make sure " + expectedProjectBuildFilePath.getFileName() + " can be read or otherwise set the 'ares.maven.ignore'/'ares.gradle.ignore' system property to true");
        }
    }

    public static AresSecurityConfigurationBuilder create() {
        return new AresSecurityConfigurationBuilder();
    }
}

