/*
 * Decompiled with CFR 0.152.
 */
package de.tum.in.test.api.io;

import de.tum.in.test.api.io.AbstractLine;
import de.tum.in.test.api.io.DynamicLine;
import de.tum.in.test.api.io.Line;
import de.tum.in.test.api.io.LineAcceptor;
import java.nio.CharBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

public final class OutputTester
implements LineAcceptor {
    private final List<Line> actualOutput = new ArrayList<Line>();

    @Override
    public void acceptOutput(CharBuffer output) {
        DynamicLine currentLine;
        if (output.length() == 0) {
            return;
        }
        if (this.getCurrentLine().map(Line::isComplete).orElse(true).booleanValue()) {
            currentLine = new DynamicLine();
            this.addNewLine(currentLine);
        } else {
            currentLine = (DynamicLine)this.getCurrentLine().get();
        }
        int lastPos = 0;
        boolean lastWasCarriageReturn = false;
        for (int i = 0; i < output.length(); ++i) {
            char c = output.charAt(i);
            if (c == '\r' || c == '\n') {
                if (c == '\n' && lastWasCarriageReturn) {
                    ++lastPos;
                } else {
                    currentLine.append(output.subSequence(lastPos, i));
                    currentLine.complete();
                    currentLine = new DynamicLine();
                    this.addNewLine(currentLine);
                    lastPos = i + 1;
                }
                lastWasCarriageReturn = c == '\r';
                continue;
            }
            if (!lastWasCarriageReturn) continue;
            lastWasCarriageReturn = false;
        }
        if (lastPos != output.length()) {
            currentLine.append(output.subSequence(lastPos, output.length()));
        }
    }

    private void addNewLine(AbstractLine line) {
        this.actualOutput.add(line);
        line.setLineNumber(this.actualOutput.size());
    }

    Optional<Line> getCurrentLine() {
        if (this.actualOutput.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(this.actualOutput.get(this.actualOutput.size() - 1));
    }

    public void resetOutput() {
        this.actualOutput.clear();
    }

    public List<Line> getOutput() {
        return Collections.unmodifiableList(this.actualOutput);
    }
}

