/*
 * Decompiled with CFR 0.152.
 */
package de.tum.in.test.api.io;

import de.tum.in.test.api.io.LineAcceptor;
import de.tum.in.test.api.localization.Messages;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CodingErrorAction;
import java.nio.charset.StandardCharsets;

final class TestOutStream
extends OutputStream {
    private static final CharsetDecoder decoder = StandardCharsets.UTF_8.newDecoder();
    private final LineAcceptor outputAcceptor;
    private final OutputStream mirror;
    private final long maxChars;
    private long charCount;
    private volatile boolean closed;
    private final ByteArrayOutputStream currentInput;

    TestOutStream(LineAcceptor outputAcceptor, OutputStream mirror, long maxChars) {
        this.mirror = mirror;
        this.outputAcceptor = outputAcceptor;
        this.currentInput = new ByteArrayOutputStream();
        this.maxChars = maxChars;
    }

    @Override
    public void write(int b) throws IOException {
        this.checkCharCount(1);
        this.currentInput.write(b);
        if (this.mirror != null) {
            this.mirror.write(b);
        }
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.checkCharCount(b.length);
        this.currentInput.write(b);
        if (this.mirror != null) {
            this.mirror.write(b);
        }
    }

    @Override
    public void write(byte[] b, int offset, int length) throws IOException {
        this.checkCharCount(length);
        this.currentInput.write(b, offset, length);
        if (this.mirror != null) {
            this.mirror.write(b, offset, length);
        }
    }

    @Override
    public void flush() throws IOException {
        CharBuffer result;
        super.flush();
        ByteBuffer bytes = ByteBuffer.wrap(this.currentInput.toByteArray());
        try {
            result = decoder.decode(bytes);
        }
        catch (CharacterCodingException e) {
            String problemString = new String(bytes.array(), decoder.charset());
            throw new IllegalArgumentException(Messages.formatLocalized("output_tester.output_is_invalid_utf8", problemString), e);
        }
        this.outputAcceptor.acceptOutput(result);
        this.currentInput.reset();
    }

    @Override
    public void close() throws IOException {
        this.closed = true;
        if (this.mirror != null) {
            this.mirror.close();
        }
    }

    private void checkCharCount(int newChars) throws IOException {
        if (this.closed) {
            throw new IOException("Stream closed");
        }
        this.charCount += (long)newChars;
        if (this.charCount > this.maxChars) {
            throw new SecurityException(Messages.formatLocalized("output_tester.output_maxExceeded", this.charCount));
        }
    }

    static {
        decoder.onUnmappableCharacter(CodingErrorAction.REPORT);
        decoder.onMalformedInput(CodingErrorAction.REPORT);
    }
}

