/*
 * Decompiled with CFR 0.152.
 */
package de.tum.in.test.api.util;

import de.tum.in.test.api.BlacklistPackage;
import de.tum.in.test.api.WhitelistPackage;
import de.tum.in.test.api.util.RuleType;
import java.util.Objects;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import org.apiguardian.api.API;

@API(status=API.Status.INTERNAL)
public final class PackageRule {
    private final RuleType ruleType;
    private final String packagePattern;
    private final Pattern regexPattern;

    private PackageRule(RuleType ruleType, String packagePattern) {
        this.ruleType = ruleType;
        this.packagePattern = packagePattern;
        this.regexPattern = PackageRule.convertPackagePatternToRegex(packagePattern);
    }

    public RuleType getRuleType() {
        return this.ruleType;
    }

    public String getPackagePattern() {
        return this.packagePattern;
    }

    public Pattern getRegexPattern() {
        return this.regexPattern;
    }

    public boolean matches(String packageName) {
        return this.regexPattern.matcher(packageName).matches();
    }

    public String toString() {
        return String.format("PackageRule[\"%s\" in %s]", new Object[]{this.packagePattern, this.ruleType});
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.packagePattern, this.ruleType});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof PackageRule)) {
            return false;
        }
        PackageRule other = (PackageRule)obj;
        return Objects.equals(this.packagePattern, other.packagePattern) && this.ruleType == other.ruleType;
    }

    private static Pattern convertPackagePatternToRegex(String packagePattern) {
        CharSequence[] parts = Pattern.quote(packagePattern).split("\\*\\*", -1);
        for (int i = 0; i < parts.length; ++i) {
            parts[i] = ((String)parts[i]).replace("*", "\\E[^.]*\\Q");
        }
        return Pattern.compile(String.join((CharSequence)"\\E.*\\Q", parts), 32);
    }

    public static Stream<PackageRule> allOf(WhitelistPackage whitelistedPackage) {
        return Stream.of(whitelistedPackage.value()).map(packagePattern -> new PackageRule(RuleType.WHITELIST, (String)packagePattern));
    }

    public static Stream<PackageRule> allOf(BlacklistPackage blacklistedPackage) {
        return Stream.of(blacklistedPackage.value()).map(packagePattern -> new PackageRule(RuleType.BLACKLIST, (String)packagePattern));
    }
}

