/*
 * Decompiled with CFR 0.152.
 */
package de.tum.in.test.api.internal;

import de.tum.in.test.api.internal.TestContext;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Stream;
import org.apiguardian.api.API;
import org.junit.platform.commons.support.AnnotationSupport;

@API(status=API.Status.INTERNAL)
public final class TestContextUtils {
    private TestContextUtils() {
    }

    public static <A extends Annotation> Optional<A> findAnnotationIn(TestContext context, Class<A> annotation) {
        return TestContextUtils.getAnnotatedElementsInnermostFirst(context).map(e -> AnnotationSupport.findAnnotation((AnnotatedElement)e, (Class)annotation)).filter(Optional::isPresent).map(Optional::get).findFirst();
    }

    public static <A extends Annotation> Stream<A> findRepeatableAnnotationsIn(TestContext context, Class<A> annotation) {
        return TestContextUtils.getAnnotatedElementsInnermostFirst(context).flatMap(e -> AnnotationSupport.findRepeatableAnnotations((AnnotatedElement)e, (Class)annotation).stream());
    }

    public static Stream<Class<?>> getClassNestingInnermostFirst(TestContext context) {
        return Stream.iterate(context.testClass().orElse(null), Class::getEnclosingClass).takeWhile(Objects::nonNull);
    }

    public static Stream<AnnotatedElement> getAnnotatedElementsInnermostFirst(TestContext context) {
        return Stream.concat(context.testMethod().stream(), TestContextUtils.getClassNestingInnermostFirst(context));
    }
}

