/*
 * Decompiled with CFR 0.152.
 */
package de.tum.in.test.api.internal.sanitization;

import de.tum.in.test.api.internal.BlacklistedInvoker;
import de.tum.in.test.api.internal.sanitization.SanitizationUtils;
import de.tum.in.test.api.internal.sanitization.SpecificThrowableSanitizer;
import java.util.List;
import java.util.Set;
import org.assertj.core.api.SoftAssertionError;

enum SoftAssertionErrorSanitizer implements SpecificThrowableSanitizer
{
    INSTANCE;

    private final Set<Class<? extends Throwable>> types = Set.of(SoftAssertionError.class);

    @Override
    public boolean canSanitize(Throwable t) {
        return this.types.contains(t.getClass());
    }

    @Override
    public Throwable sanitize(Throwable t) {
        SoftAssertionError sae = new SoftAssertionError(BlacklistedInvoker.invoke(() -> List.copyOf(((SoftAssertionError)t).getErrors())));
        SanitizationUtils.copyThrowableInfoSafe(t, (Throwable)sae);
        return sae;
    }
}

