/*
 * Decompiled with CFR 0.152.
 */
package de.tum.in.test.api.internal.sanitization;

import de.tum.in.test.api.internal.BlacklistedInvoker;
import de.tum.in.test.api.internal.ThrowableUtils;
import de.tum.in.test.api.internal.sanitization.SanitizationAction;
import de.tum.in.test.api.internal.sanitization.SanitizationException;
import de.tum.in.test.api.internal.sanitization.ThrowableSanitizer;
import de.tum.in.test.api.security.ArtemisSecurityManager;
import de.tum.in.test.api.util.IgnorantUnmodifiableList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

final class SanitizationUtils {
    private SanitizationUtils() {
    }

    static void copyThrowableInfoSafe(Throwable from, Throwable to) {
        if (from != to) {
            ThrowableUtils.setDetailMessage(to, ThrowableUtils.getDetailMessage(from));
            to.setStackTrace(from.getStackTrace());
        }
        Throwable causeVal = BlacklistedInvoker.invoke(from::getCause);
        Throwable[] supprVal = BlacklistedInvoker.invoke(from::getSuppressed);
        Throwable newCause = ThrowableSanitizer.sanitize(causeVal);
        ThrowableUtils.setCause(to, newCause);
        List<Throwable> newSupressed = IgnorantUnmodifiableList.wrapWith(Arrays.stream(supprVal).map(ThrowableSanitizer::sanitize).collect(Collectors.toList()), ArtemisSecurityManager.getOnSuppressedModification());
        ThrowableUtils.setSuppressedException(to, newSupressed);
    }

    static <T> T sanitizeWithinScopeOf(Object scope, SanitizationAction<T> sanitizationAction) {
        return SanitizationUtils.sanitizeWithinScopeOf(scope.getClass(), sanitizationAction);
    }

    static <T> T sanitizeWithinScopeOf(Class<?> scope, SanitizationAction<T> sanitizationAction) {
        try {
            return sanitizationAction.executeSanitization();
        }
        catch (SanitizationException sanitizationException) {
            throw sanitizationException;
        }
        catch (Throwable t) {
            throw new SanitizationException(scope, t);
        }
    }
}

