/*
 * Decompiled with CFR 0.152.
 */
package de.tum.in.test.api.dynamic;

import de.tum.in.test.api.dynamic.Check;
import de.tum.in.test.api.dynamic.Checkable;
import de.tum.in.test.api.dynamic.DynamicClass;
import de.tum.in.test.api.util.UnexpectedExceptionError;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.Collection;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apiguardian.api.API;
import org.junit.jupiter.api.Assertions;

@API(status=API.Status.EXPERIMENTAL)
public class DynamicMethod<T>
implements Checkable {
    private final DynamicClass<?> owner;
    private final String name;
    private final DynamicClass<?>[] parameters;
    private final DynamicClass<T> returnType;
    private Method m;

    public DynamicMethod(DynamicClass<?> dClass, Class<T> dynamicableReturn, String mName, Object ... dynamicableParams) {
        this(dClass, DynamicClass.toDynamic(dynamicableReturn), mName, dynamicableParams);
    }

    public DynamicMethod(DynamicClass<?> dClass, DynamicClass<T> dynamicableReturn, String mName, Object ... dynamicableParams) {
        this.owner = Objects.requireNonNull(dClass);
        this.name = Objects.requireNonNull(mName);
        this.returnType = Objects.requireNonNull(dynamicableReturn);
        this.parameters = DynamicClass.toDynamic(Objects.requireNonNull(dynamicableParams));
    }

    public Method toMethod() {
        if (this.m == null) {
            try {
                this.m = this.owner.toClass().getDeclaredMethod(this.name, DynamicClass.resolveAll(this.parameters));
                this.m.trySetAccessible();
                if (!this.returnType.toClass().isAssignableFrom(this.m.getReturnType())) {
                    Assertions.fail((String)("Methode " + this.name + " mit Parametern " + DynamicMethod.descParams(this.parameters) + " gibt nicht " + this.returnType + " zur\u00fcck"));
                }
            }
            catch (NoSuchMethodException e) {
                Assertions.fail((String)("Keine Methode " + this.returnType + " " + this + " gefunden."), (Throwable)e);
            }
        }
        return this.m;
    }

    public boolean exists() {
        if (this.m == null) {
            try {
                this.m = this.owner.toClass().getDeclaredMethod(this.name, DynamicClass.resolveAll(this.parameters));
                this.m.trySetAccessible();
                if (!this.returnType.toClass().isAssignableFrom(this.m.getReturnType())) {
                    return false;
                }
            }
            catch (Exception e) {
                return false;
            }
        }
        return true;
    }

    public T invokeOn(Object o, Object ... params) {
        try {
            return this.returnType.cast(this.toMethod().invoke(o, params));
        }
        catch (NullPointerException e) {
            Assertions.fail((String)("Methode " + this + " konnte nicht aufgerufen werden, das Objekt ist null"), (Throwable)e);
        }
        catch (IllegalAccessException e) {
            Assertions.fail((String)("Methode " + this + " konnte nicht aufgerufen werden, Zugriff auf die Methode nicht m\u00f6glich"), (Throwable)e);
        }
        catch (IllegalArgumentException e) {
            Assertions.fail((String)("Methode " + this + " konnte Parametertypen " + DynamicMethod.descArgs(params) + " f\u00fcr Objekt " + o + " nicht entgegennehmen"), (Throwable)e);
        }
        catch (InvocationTargetException e) {
            if (e.getTargetException() instanceof RuntimeException) {
                throw (RuntimeException)e.getTargetException();
            }
            throw UnexpectedExceptionError.wrap(e.getTargetException());
        }
        catch (ClassCastException e) {
            Assertions.fail((String)("R\u00fcckgabe von " + this.name + " mit Parametern " + DynamicMethod.descParams(this.parameters) + " der Klasse " + this.owner + " kann nicht nach " + this.returnType + "gecastet werden"), (Throwable)e);
        }
        return null;
    }

    public T invokeStatic(Object ... params) {
        if (!Modifier.isStatic(this.toMethod().getModifiers())) {
            Assertions.fail((String)("Methode " + this + " ist nicht statisch"));
        }
        return this.invokeOn(null, params);
    }

    public <R> R invokeOnCast(Object o, Object ... params) {
        try {
            return (R)this.invokeOn(o, params);
        }
        catch (ClassCastException e) {
            throw new ClassCastException("Return type cast error in " + this.toString() + ": " + e.getMessage());
        }
    }

    public <R> R invokeStaticCast(Object ... params) {
        try {
            return (R)this.invokeStatic(params);
        }
        catch (ClassCastException e) {
            throw new ClassCastException("Return type cast error in " + this.toString() + ": " + e.getMessage());
        }
    }

    public String toString() {
        return this.owner.toString() + "." + this.signature();
    }

    public String signature() {
        return this.name + DynamicMethod.descParams(this.parameters);
    }

    public static String signatureOf(Method method) {
        return method.getName() + DynamicMethod.descParams(DynamicClass.toDynamic(method.getParameterTypes()));
    }

    public static String[] signatureOfAll(Method ... methods) {
        return (String[])Arrays.stream(methods).map(DynamicMethod::signatureOf).toArray(String[]::new);
    }

    public static String[] signatureOfAll(DynamicMethod<?> ... methods) {
        return (String[])Arrays.stream(methods).map(DynamicMethod::signature).toArray(String[]::new);
    }

    public static String[] signatureOfAll(Collection<Method> methods) {
        return (String[])methods.stream().map(DynamicMethod::signatureOf).toArray(String[]::new);
    }

    public static <T> String[] signatureOfAll(T methods) {
        return (String[])((Collection)methods).stream().map(DynamicMethod::signature).toArray(String[]::new);
    }

    public static String descArgs(Object ... args) {
        return Arrays.stream(args).map(x -> x == null ? null : args.getClass().getCanonicalName()).collect(Collectors.joining(", ", "(", ")"));
    }

    public static String descParams(DynamicClass<?> ... params) {
        return Arrays.stream(params).map(DynamicClass::getName).collect(Collectors.joining(", ", "(", ")"));
    }

    @Override
    public void check(Check ... checks) {
        int modifiers = this.toMethod().getModifiers();
        String desc = "Methode " + this;
        for (Check check : checks) {
            check.checkModifiers(modifiers, desc);
        }
    }
}

