/*
 * Decompiled with CFR 0.152.
 */
package de.tum.in.test.api.io;

import de.tum.in.test.api.io.Line;
import de.tum.in.test.api.localization.Messages;
import java.util.Objects;

public abstract class AbstractLine
implements Line {
    int lineNumber = -1;

    @Override
    public String toString() {
        return this.lineNumber == -1 ? Messages.formatLocalized("abstract_line.plain_line", this.text()) : Messages.formatLocalized("abstract_line.numbered_line", this.lineNumber, this.text());
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof AbstractLine)) {
            return false;
        }
        Line other = (Line)obj;
        return Objects.equals(this.text(), other.text());
    }

    public int hashCode() {
        return this.text().hashCode();
    }

    @Override
    public final int lineNumber() {
        return this.lineNumber;
    }

    public final void setLineNumber(int lineNumber) {
        if (lineNumber <= 0) {
            throw new IllegalArgumentException("Line number cannot be set to " + lineNumber);
        }
        if (this.lineNumber != -1) {
            throw new IllegalStateException("Line number has already been set");
        }
        this.lineNumber = lineNumber;
    }

    static boolean containsLineBreaks(CharSequence text) {
        for (int i = 0; i < text.length(); ++i) {
            char c = text.charAt(i);
            if (c != '\r' && c != '\n') continue;
            return true;
        }
        return false;
    }
}

