/*
 * Decompiled with CFR 0.152.
 */
package de.tum.in.test.api.localization;

import de.tum.in.test.api.util.LruCache;
import java.util.Collections;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.apiguardian.api.API;

@API(status=API.Status.INTERNAL)
public final class Messages {
    private static final String BUNDLE_NAME = "de.tum.in.test.api.localization.messages";
    private static Map<Locale, ResourceBundle> resourceBundleCache = Collections.synchronizedMap(new LruCache(100));

    private Messages() {
    }

    public static String localized(String key) {
        try {
            return Messages.getBundleForCurrentLocale().getString(key);
        }
        catch (MissingResourceException e) {
            return "!" + key + "!";
        }
    }

    public static String formatLocalized(String key, Object ... args) {
        try {
            return String.format(Messages.getBundleForCurrentLocale().getString(key), args);
        }
        catch (MissingResourceException e) {
            return "!" + key + "!";
        }
    }

    private static ResourceBundle getBundleForCurrentLocale() {
        return resourceBundleCache.computeIfAbsent(Locale.getDefault(Locale.Category.DISPLAY), Messages::loadBundleForLocale);
    }

    private static ResourceBundle loadBundleForLocale(Locale locale) {
        return ResourceBundle.getBundle(BUNDLE_NAME, locale);
    }

    public static void init() {
    }
}

