/*
 * Decompiled with CFR 0.152.
 */
package de.tum.in.test.api.internal.sanitization;

import de.tum.in.test.api.internal.sanitization.MessageTransformer;
import de.tum.in.test.api.internal.sanitization.SanitizationUtils;
import de.tum.in.test.api.internal.sanitization.SpecificThrowableSanitizer;
import de.tum.in.test.api.internal.sanitization.ThrowableInfo;
import de.tum.in.test.api.internal.sanitization.ThrowableSanitizer;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.assertj.core.error.AssertJMultipleFailuresError;
import org.opentest4j.MultipleFailuresError;

enum MultipleFailuresErrorSanitizer implements SpecificThrowableSanitizer
{
    INSTANCE;

    private final Set<Class<? extends Throwable>> types = Set.of(MultipleFailuresError.class, AssertJMultipleFailuresError.class);

    @Override
    public boolean canSanitize(Throwable t) {
        return this.types.contains(t.getClass());
    }

    @Override
    public Throwable sanitize(Throwable t, MessageTransformer messageTransformer) {
        MultipleFailuresError mfe = (MultipleFailuresError)t;
        ThrowableInfo info = ThrowableInfo.getEssentialInfosSafeFrom((Throwable)mfe).sanitize();
        List failures = mfe.getFailures().stream().map(ThrowableSanitizer::sanitize).collect(Collectors.toUnmodifiableList());
        MultipleFailuresError newMfe = MultipleFailuresErrorSanitizer.createNewInstance((Throwable)mfe, info.getMessage(), List.of());
        SanitizationUtils.copyThrowableInfoSafe(info, (Throwable)newMfe);
        for (Throwable failure : failures) {
            newMfe.addSuppressed(failure);
        }
        return newMfe;
    }

    private static MultipleFailuresError createNewInstance(Throwable t, String heading, List<Throwable> failures) {
        if (t.getClass().equals(MultipleFailuresError.class)) {
            return new MultipleFailuresError(heading, failures);
        }
        return new AssertJMultipleFailuresError(heading, failures);
    }
}

