/*
 * Decompiled with CFR 0.152.
 */
package de.tum.in.test.api.internal.sanitization;

import de.tum.in.test.api.internal.sanitization.ArbitraryThrowableSanitizer;
import de.tum.in.test.api.internal.sanitization.MessageTransformer;
import de.tum.in.test.api.internal.sanitization.SanitizationUtils;
import de.tum.in.test.api.internal.sanitization.SpecificThrowableSanitizer;
import de.tum.in.test.api.internal.sanitization.ThrowableCreator;
import de.tum.in.test.api.internal.sanitization.ThrowableInfo;
import de.tum.in.test.api.internal.sanitization.ThrowableSets;
import de.tum.in.test.api.internal.sanitization.ThrowableUtils;
import de.tum.in.test.api.util.LruCache;
import java.net.HttpRetryException;
import java.time.format.DateTimeParseException;
import java.util.Collections;
import java.util.IllformedLocaleException;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.Set;
import java.util.function.Supplier;
import junit.framework.ComparisonCompactor;
import org.assertj.core.api.Assertions;
import org.junit.ComparisonFailure;
import org.junit.experimental.theories.internal.ParameterizedAssertionError;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

enum SafeTypeThrowableSanitizer implements SpecificThrowableSanitizer
{
    INSTANCE;

    private static final Logger LOG;
    static final Set<String> NON_DUPLICATABLE_SAFE_TYPES;
    static final Map<String, ThrowableCreator> SPECIFIC_CREATORS;
    final Map<Class<? extends Throwable>, ThrowableCreator> cachedThrowableCreators = Collections.synchronizedMap(new LruCache(1000));

    @Override
    public boolean canSanitize(Throwable t) {
        Class<?> type = t.getClass();
        boolean isSafe = ThrowableSets.SAFE_TYPES.contains(type);
        boolean isDuplicatable = !NON_DUPLICATABLE_SAFE_TYPES.contains(type.getName());
        return isSafe && isDuplicatable;
    }

    @Override
    public Throwable sanitize(Throwable t, MessageTransformer messageTransformer) {
        Class<?> type = t.getClass();
        ThrowableInfo info = ThrowableInfo.of(type, ThrowableUtils.retrievePropertyValues(t));
        info.sanitize(ThrowableUtils.PROPERTY_SANITIZER);
        info.setMessage(messageTransformer.apply(info));
        ThrowableCreator throwableCreator = this.cachedThrowableCreators.computeIfAbsent(type, this::findThrowableCreator);
        try {
            Throwable newInstance = throwableCreator.create(info);
            SanitizationUtils.copyThrowableInfoSafe(info, newInstance);
            return newInstance;
        }
        catch (RuntimeException e) {
            LOG.warn("Failed to sanitize an exception of type {}.", type, (Object)e);
            return ArbitraryThrowableSanitizer.INSTANCE.sanitize(t, messageTransformer);
        }
    }

    private ThrowableCreator findThrowableCreator(Class<? extends Throwable> type) {
        ThrowableCreator throwableCreator = SPECIFIC_CREATORS.get(type.getName());
        if (throwableCreator == null) {
            throwableCreator = ThrowableUtils.getThrowableCreatorFor(type);
        }
        return throwableCreator;
    }

    static {
        LOG = LoggerFactory.getLogger(SafeTypeThrowableSanitizer.class);
        NON_DUPLICATABLE_SAFE_TYPES = Set.of("java.io.OptionalDataException", "java.util.IllegalFormatException", "net.jqwik.api.configurators.ArbitraryConfigurationException", "net.jqwik.api.lifecycle.CannotFindStoreException", "net.jqwik.api.lifecycle.CannotResolveParameterException", "net.jqwik.engine.execution.pipeline.DuplicateExecutionTaskException", "net.jqwik.engine.execution.pipeline.PredecessorNotSubmittedException", "net.jqwik.engine.properties.arbitraries.NotAFunctionalTypeException", "org.junit.Test$None", "org.junit.internal.ArrayComparisonFailure", "org.junit.runner.FilterFactory$FilterNotCreatedException");
        SPECIFIC_CREATORS = Map.ofEntries(new Map.Entry[]{Assertions.entry((Object)"java.net.HttpRetryException", (Object)new HttpRetryExceptionCreator()), Assertions.entry((Object)"java.time.format.DateTimeParseException", (Object)new DateTimeParseExceptionCreator()), Assertions.entry((Object)"java.util.IllformedLocaleException", (Object)new IllformedLocaleExceptionCreator()), Assertions.entry((Object)"java.util.MissingResourceException", (Object)new MissingResourceExceptionCreator()), Assertions.entry((Object)"junit.framework.ComparisonFailure", (Object)new ThrowableCreatorWrapper(() -> new ComparisonFailureCreator())), Assertions.entry((Object)"org.junit.ComparisonFailure", (Object)new ThrowableCreatorWrapper(() -> new ComparisonFailureCreator())), Assertions.entry((Object)"org.junit.experimental.theories.internal.ParameterizedAssertionError", (Object)new ThrowableCreatorWrapper(() -> new ParameterizedAssertionErrorCreator()))});
    }

    private static class ParameterizedAssertionErrorCreator
    implements ThrowableCreator {
        private ParameterizedAssertionErrorCreator() {
        }

        @Override
        public Throwable create(ThrowableInfo info) {
            String message;
            Throwable targetException = info.getCause();
            String methodName = message = info.getMessage();
            Object[] params = new Object[]{};
            try {
                String[] parts = message.substring(0, message.length() - 1).split("\\(", 2);
                methodName = parts[0];
                params = parts[1].split(",");
            }
            catch (RuntimeException runtimeException) {
                // empty catch block
            }
            return new ParameterizedAssertionError(targetException, methodName, params);
        }
    }

    private static class ComparisonFailureCreator
    implements ThrowableCreator {
        private static final int MAX_CONTEXT_LENGTH = 20;
        private static final ThrowableInfo.PropertyKey<String> EXPECTED = new ThrowableInfo.PropertyKey<String>(String.class, "expected");
        private static final ThrowableInfo.PropertyKey<String> ACTUAL = new ThrowableInfo.PropertyKey<String>(String.class, "actual");

        private ComparisonFailureCreator() {
        }

        @Override
        public Throwable create(ThrowableInfo info) {
            String actual;
            String expected;
            String withoutMessage;
            String message = info.getMessage();
            String start = SanitizationUtils.removeSuffixMatching(message, withoutMessage = new ComparisonCompactor(20, expected = info.getProperty(EXPECTED), actual = info.getProperty(ACTUAL)).compact(""));
            message = start == null ? "" : start.trim();
            if (junit.framework.ComparisonFailure.class.isAssignableFrom(info.getType())) {
                return new junit.framework.ComparisonFailure(message, expected, actual);
            }
            return new ComparisonFailure(message, expected, actual);
        }
    }

    private static class MissingResourceExceptionCreator
    implements ThrowableCreator {
        private static final ThrowableInfo.PropertyKey<String> CLASS_NAME = new ThrowableInfo.PropertyKey<String>(String.class, "className");
        private static final ThrowableInfo.PropertyKey<String> KEY = new ThrowableInfo.PropertyKey<String>(String.class, "key");

        private MissingResourceExceptionCreator() {
        }

        @Override
        public Throwable create(ThrowableInfo info) {
            String message = info.getMessage();
            String className = info.getProperty(CLASS_NAME);
            String key = info.getProperty(KEY);
            return new MissingResourceException(message, className, key);
        }
    }

    private static class IllformedLocaleExceptionCreator
    implements ThrowableCreator {
        private IllformedLocaleExceptionCreator() {
        }

        @Override
        public Throwable create(ThrowableInfo info) {
            return new IllformedLocaleException(info.getMessage());
        }
    }

    private static class DateTimeParseExceptionCreator
    implements ThrowableCreator {
        private static final ThrowableInfo.PropertyKey<String> PARSED_STRING = new ThrowableInfo.PropertyKey<String>(String.class, "parsedString");
        private static final ThrowableInfo.PropertyKey<Integer> ERROR_INDEX = new ThrowableInfo.PropertyKey<Integer>(Integer.TYPE, "errorIndex");

        private DateTimeParseExceptionCreator() {
        }

        @Override
        public Throwable create(ThrowableInfo info) {
            String message = info.getMessage();
            String parsedData = info.getProperty(PARSED_STRING);
            Integer errorIndex = info.getProperty(ERROR_INDEX);
            return new DateTimeParseException(message, parsedData, errorIndex);
        }
    }

    private static class HttpRetryExceptionCreator
    implements ThrowableCreator {
        private static final ThrowableInfo.PropertyKey<Integer> RESPONSE_CODE = new ThrowableInfo.PropertyKey<Integer>(Integer.TYPE, "responseCode");
        private static final ThrowableInfo.PropertyKey<String> LOCATION = new ThrowableInfo.PropertyKey<String>(String.class, "location");

        private HttpRetryExceptionCreator() {
        }

        @Override
        public Throwable create(ThrowableInfo info) {
            String detail = info.getMessage();
            Integer code = info.getProperty(RESPONSE_CODE);
            String location = info.getProperty(LOCATION);
            return new HttpRetryException(detail, code, location);
        }
    }

    private static class ThrowableCreatorWrapper
    implements ThrowableCreator {
        private final Supplier<ThrowableCreator> throwableCreatorSupplier;
        private ThrowableCreator throwableCreator;

        private ThrowableCreatorWrapper(Supplier<ThrowableCreator> throwableCreatorSupplier) {
            this.throwableCreatorSupplier = throwableCreatorSupplier;
        }

        @Override
        public Throwable create(ThrowableInfo throwableInfo) {
            if (this.throwableCreator == null) {
                this.throwableCreator = this.throwableCreatorSupplier.get();
            }
            return this.throwableCreator.create(throwableInfo);
        }
    }
}

