/*
 * Decompiled with CFR 0.152.
 */
package de.tum.in.test.api.internal.sanitization;

import de.tum.in.test.api.internal.BlacklistedInvoker;
import de.tum.in.test.api.internal.sanitization.MessageTransformer;
import de.tum.in.test.api.internal.sanitization.SanitizationUtils;
import de.tum.in.test.api.internal.sanitization.SpecificThrowableSanitizer;
import de.tum.in.test.api.internal.sanitization.ThrowableInfo;
import java.util.Set;
import org.opentest4j.AssertionFailedError;
import org.opentest4j.ValueWrapper;

enum AssertionFailedErrorSanitizer implements SpecificThrowableSanitizer
{
    INSTANCE;

    private final Set<Class<? extends Throwable>> types = Set.of(AssertionFailedError.class);

    @Override
    public boolean canSanitize(Throwable t) {
        return this.types.contains(t.getClass());
    }

    @Override
    public Throwable sanitize(Throwable t, MessageTransformer messageTransformer) {
        AssertionFailedError afe = (AssertionFailedError)t;
        ValueWrapper expected = afe.getExpected();
        ValueWrapper actual = afe.getExpected();
        ThrowableInfo info = ThrowableInfo.getEssentialInfosSafeFrom(t).sanitize();
        String newMessage = messageTransformer.apply(info);
        AssertionFailedError newAfe = new AssertionFailedError(newMessage, AssertionFailedErrorSanitizer.sanitizeValue(expected), AssertionFailedErrorSanitizer.sanitizeValue(actual));
        SanitizationUtils.copyThrowableInfoSafe(info, (Throwable)newAfe);
        return newAfe;
    }

    private static Object sanitizeValue(ValueWrapper vw) {
        if (vw == null) {
            return null;
        }
        return SanitizationUtils.sanitizeWithinScopeOf(vw.getType(), () -> BlacklistedInvoker.invoke(() -> ((ValueWrapper)vw).getStringRepresentation()));
    }
}

