/*
 * Decompiled with CFR 0.152.
 */
package de.tum.in.test.api.jqwik;

import de.tum.in.test.api.internal.IOTesterManager;
import de.tum.in.test.api.io.IOTester;
import de.tum.in.test.api.jqwik.JqwikContext;
import java.util.Set;
import net.jqwik.api.Arbitraries;
import net.jqwik.api.Arbitrary;
import net.jqwik.api.lifecycle.AroundPropertyHook;
import net.jqwik.api.lifecycle.PropertyExecutionResult;
import net.jqwik.api.lifecycle.PropertyExecutor;
import net.jqwik.api.lifecycle.PropertyLifecycleContext;
import net.jqwik.api.providers.ArbitraryProvider;
import net.jqwik.api.providers.TypeUsage;
import net.jqwik.engine.providers.RegisteredArbitraryProviders;
import org.apiguardian.api.API;

@API(status=API.Status.INTERNAL)
public final class JqwikIOExtension
implements AroundPropertyHook {
    public int aroundPropertyProximity() {
        return 20;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PropertyExecutionResult aroundProperty(PropertyLifecycleContext context, PropertyExecutor property) throws Throwable {
        IOTesterManager ioTesterManager = new IOTesterManager(JqwikContext.of(context));
        ioTesterManager.beforeTestExecution();
        IOTesterProvider ioTesterProvider = new IOTesterProvider(ioTesterManager.getIOTester());
        RegisteredArbitraryProviders.register((ArbitraryProvider)ioTesterProvider);
        try {
            PropertyExecutionResult propertyExecutionResult = property.execute();
            return propertyExecutionResult;
        }
        finally {
            RegisteredArbitraryProviders.unregister((ArbitraryProvider)ioTesterProvider);
            ioTesterManager.afterTestExecution();
        }
    }

    private static class IOTesterProvider
    implements ArbitraryProvider {
        private final IOTester ioTester;

        public IOTesterProvider(IOTester ioTester) {
            this.ioTester = ioTester;
        }

        public boolean canProvideFor(TypeUsage targetType) {
            return targetType.getRawType().equals(IOTester.class);
        }

        public Set<Arbitrary<?>> provideFor(TypeUsage targetType, ArbitraryProvider.SubtypeProvider subtypeProvider) {
            return Set.of(Arbitraries.just((Object)this.ioTester));
        }
    }
}

