/*
 * Decompiled with CFR 0.152.
 */
package de.tum.in.test.api.internal;

import de.tum.in.test.api.internal.ConfigurationUtils;
import de.tum.in.test.api.internal.TestContext;
import de.tum.in.test.api.io.IOTester;
import de.tum.in.test.api.security.ArtemisSecurityManager;
import org.apiguardian.api.API;

@API(status=API.Status.INTERNAL)
public final class IOTesterManager {
    private final TestContext context;
    private IOTester ioTester;

    public IOTesterManager(TestContext context) {
        this.context = context;
    }

    public void beforeTestExecution() {
        boolean mirrorOutput = ConfigurationUtils.shouldMirrorOutput(this.context);
        long maxStdOut = ConfigurationUtils.getMaxStandardOutput(this.context);
        this.ioTester = IOTester.installNew(mirrorOutput, maxStdOut);
    }

    public void afterTestExecution() {
        IOTester.uninstallCurrent();
        this.ioTester = null;
    }

    public IOTester getIOTester() {
        return this.ioTester;
    }

    static {
        ArtemisSecurityManager.isInstalled();
    }
}

